/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session.store;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import nablarch.common.encryption.AesEncryptor;
import nablarch.common.encryption.Encryptor;
import nablarch.common.web.session.EncodeException;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionStore;
import nablarch.core.util.FileUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HiddenStore
extends SessionStore {
    private static final Charset SESSION_ID_ENCODING = Charset.forName("UTF-8");
    private static final int SESSION_ID_LENGTH_BYTES = 4;
    private Encryptor encryptor;
    private Serializable context;
    private String parameterName = "nablarch_hiddenStore";

    public HiddenStore() {
        super("hidden");
        AesEncryptor defaultEncryptor = new AesEncryptor();
        this.setEncryptor((Encryptor)defaultEncryptor);
    }

    @Override
    public void save(String sessionId, List<SessionEntry> entries, ExecutionContext executionContext) {
        byte[] serialized = this.serialize(sessionId, entries);
        byte[] encrypted = this.encryptor.encrypt(this.context, serialized);
        String base64Encoded = DatatypeConverter.printBase64Binary((byte[])encrypted);
        executionContext.setRequestScopedVar(this.parameterName, (Object)base64Encoded);
    }

    @Override
    public List<SessionEntry> load(String currentSessionId, ExecutionContext executionContext) {
        ServletExecutionContext servlet = (ServletExecutionContext)executionContext;
        String[] hidden = servlet.getHttpRequest().getParam(this.parameterName);
        if (hidden == null || hidden.length == 0) {
            return Collections.emptyList();
        }
        try {
            String base64Encoded = hidden[0];
            byte[] encrypted = DatatypeConverter.parseBase64Binary((String)base64Encoded);
            byte[] serialized = this.encryptor.decrypt(this.context, encrypted);
            return this.deserializeAndValidateSessionId(serialized, currentSessionId);
        }
        catch (Exception e) {
            throw new HiddenStoreLoadFailedException(e);
        }
    }

    private byte[] serialize(String sessionId, List<SessionEntry> entries) {
        byte[] sidBytes = sessionId.getBytes(SESSION_ID_ENCODING);
        byte[] sidLengthBytes = ByteBuffer.allocate(4).putInt(sidBytes.length).array();
        byte[] entriesBytes = this.encode(entries);
        return this.concat(sidLengthBytes, sidBytes, entriesBytes);
    }

    private List<SessionEntry> deserializeAndValidateSessionId(byte[] serialized, String currentSessionId) {
        if (serialized.length == 0) {
            return Collections.emptyList();
        }
        byte[] sidLengthBytes = this.copy(serialized, 0, 4);
        int sidByteLength = ByteBuffer.wrap(sidLengthBytes).getInt();
        byte[] sidBytes = this.copy(serialized, 4, sidByteLength);
        String sessionIdFromHidden = new String(sidBytes, SESSION_ID_ENCODING);
        this.validate(currentSessionId, sessionIdFromHidden);
        int sessionIdSectionByteLength = 4 + sidByteLength;
        int entriesByteLength = serialized.length - sessionIdSectionByteLength;
        byte[] entriesBytes = this.copy(serialized, sessionIdSectionByteLength, entriesByteLength);
        return this.decode(entriesBytes);
    }

    private void validate(String currentSessionId, String sessionIdFromHidden) {
        if (currentSessionId.equals(sessionIdFromHidden)) {
            return;
        }
        throw new EncodeException(new RuntimeException("Invalid Session ID detected."));
    }

    private byte[] copy(byte[] src, int srcPos, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(src, srcPos, dest, 0, length);
        return dest;
    }

    private byte[] concat(byte[] ... byteArrays) {
        int totalLenght = 0;
        for (byte[] bs : byteArrays) {
            totalLenght += bs.length;
        }
        ByteArrayOutputStream dest = new ByteArrayOutputStream(totalLenght);
        try {
            for (byte[] byteArray : byteArrays) {
                dest.write(byteArray);
            }
        }
        catch (IOException e) {
            try {
                throw new EncodeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{dest});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{dest});
        return dest.toByteArray();
    }

    @Override
    public void delete(String sessionId, ExecutionContext executionContext) {
        executionContext.getRequestScopeMap().remove(this.parameterName);
    }

    @Override
    public void invalidate(String sessionId, ExecutionContext executionContext) {
        executionContext.getRequestScopeMap().remove(this.parameterName);
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
        this.context = encryptor.generateContext();
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public static class HiddenStoreLoadFailedException
    extends EncodeException {
        public HiddenStoreLoadFailedException(Exception cause) {
            super(cause);
        }
    }
}

