/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.token;

import nablarch.common.web.token.DoubleSubmissionHandler;
import nablarch.common.web.token.OnDoubleSubmission;
import nablarch.common.web.token.TokenUtil;
import nablarch.core.message.ApplicationException;
import nablarch.core.message.Message;
import nablarch.core.message.MessageLevel;
import nablarch.core.message.MessageUtil;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;

public class BasicDoubleSubmissionHandler
implements DoubleSubmissionHandler {
    private String path;
    private String messageId;
    private int statusCode = 400;

    public void setPath(String path) {
        this.path = path;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context, Handler<HttpRequest, HttpResponse> originalHandler, OnDoubleSubmission annotation) {
        if (!TokenUtil.isValidToken(request, context)) {
            int usingStatusCode;
            String usingMessageId;
            String usingPath = annotation.path();
            if (StringUtil.isNullOrEmpty((String)usingPath)) {
                usingPath = this.path;
            }
            if (StringUtil.isNullOrEmpty((String)(usingMessageId = annotation.messageId()))) {
                usingMessageId = this.messageId;
            }
            if ((usingStatusCode = annotation.statusCode()) == -1) {
                usingStatusCode = this.statusCode;
            }
            if (usingMessageId == null) {
                throw new HttpErrorResponse(usingStatusCode, usingPath);
            }
            Message message = MessageUtil.createMessage((MessageLevel)MessageLevel.ERROR, (String)usingMessageId, (Object[])new Object[0]);
            throw new HttpErrorResponse(usingStatusCode, usingPath, (Throwable)new ApplicationException(message));
        }
        return (HttpResponse)originalHandler.handle((Object)request, context);
    }
}

