/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.token;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nablarch.common.web.token.BasicDoubleSubmissionHandler;
import nablarch.common.web.token.DoubleSubmissionHandler;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Interceptor;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;

@Documented
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Interceptor(value=Impl.class)
@Published
public @interface OnDoubleSubmission {
    public String path() default "";

    public String messageId() default "";

    public int statusCode() default -1;

    public static class Impl
    extends Interceptor.Impl<HttpRequest, HttpResponse, OnDoubleSubmission> {
        private static final DoubleSubmissionHandler DEFAULT_HANDLER = new BasicDoubleSubmissionHandler();
        private static final String DOUBLE_SUBMISSION_HANDLER_NAME = "doubleSubmissionHandler";

        public HttpResponse handle(HttpRequest request, ExecutionContext context) {
            DoubleSubmissionHandler handler = (DoubleSubmissionHandler)SystemRepository.getObject((String)DOUBLE_SUBMISSION_HANDLER_NAME);
            if (handler == null) {
                handler = DEFAULT_HANDLER;
            }
            return handler.handle(request, context, (Handler<HttpRequest, HttpResponse>)this.getOriginalHandler(), (OnDoubleSubmission)this.getInterceptor());
        }
    }
}

