/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.token;

import nablarch.common.web.WebConfig;
import nablarch.common.web.WebConfigFinder;
import nablarch.common.web.token.HttpSessionTokenManager;
import nablarch.common.web.token.TokenGenerator;
import nablarch.common.web.token.TokenManager;
import nablarch.common.web.token.UUIDV4TokenGenerator;
import nablarch.core.repository.SystemRepository;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

public final class TokenUtil {
    private static final String TOKEN_GENERATOR_NAME = "tokenGenerator";

    private TokenUtil() {
    }

    public static String generateToken(NablarchHttpServletRequestWrapper request) {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        String token = (String)request.getAttribute(webConfig.getDoubleSubmissionTokenRequestAttributeName());
        if (token == null) {
            token = TokenUtil.getTokenGenerator().generate();
            request.setAttribute(webConfig.getDoubleSubmissionTokenRequestAttributeName(), token);
            TokenUtil.getTokenManager().saveToken(token, request);
        }
        return token;
    }

    public static TokenGenerator getTokenGenerator() {
        TokenGenerator generator = (TokenGenerator)SystemRepository.getObject((String)TOKEN_GENERATOR_NAME);
        return generator != null ? generator : new UUIDV4TokenGenerator();
    }

    public static synchronized boolean isValidToken(HttpRequest request, ExecutionContext context) throws ClassCastException {
        boolean validToken;
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        String[] tokenParam = request.getParam(webConfig.getDoubleSubmissionTokenParameterName());
        if (tokenParam != null && tokenParam.length == 1) {
            String clientToken = tokenParam[0];
            validToken = TokenUtil.getTokenManager().isValidToken(clientToken, (ServletExecutionContext)context);
        } else {
            validToken = false;
        }
        return validToken;
    }

    private static TokenManager getTokenManager() {
        TokenManager tokenManager = (TokenManager)SystemRepository.get((String)"tokenManager");
        if (tokenManager == null) {
            return new HttpSessionTokenManager();
        }
        return tokenManager;
    }
}

