/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util.map;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import nablarch.core.util.map.MapWrapper;

public abstract class AttributeMap<K, V>
extends MapWrapper<K, V> {
    public abstract V getAttribute(K var1);

    public abstract Enumeration<K> getAttributeNames();

    public abstract void setAttribute(K var1, V var2);

    public abstract void removeAttribute(K var1);

    public synchronized int size() {
        int result = 0;
        Enumeration<K> attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            attrNames.nextElement();
            ++result;
        }
        return result;
    }

    public V get(Object key) {
        return this.getAttribute(key);
    }

    public synchronized V remove(Object key) {
        Enumeration<K> attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            K attrName = attrNames.nextElement();
            boolean bl = key == null ? attrName == null : key.equals(attrName);
            boolean found = bl;
            if (!found) continue;
            V oldVal = this.getAttribute(key);
            this.removeAttribute(key);
            return oldVal;
        }
        return null;
    }

    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public synchronized V put(K key, V value) {
        V oldVal = this.getAttribute(key);
        this.setAttribute(key, value);
        return oldVal;
    }

    public synchronized void clear() {
        Enumeration<K> attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            K attrName = attrNames.nextElement();
            this.removeAttribute(attrName);
        }
    }

    public synchronized boolean containsKey(Object key) {
        Enumeration<K> attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            K attrName = attrNames.nextElement();
            boolean bl = key == null ? attrName == null : key.equals(attrName);
            boolean found = bl;
            if (!found) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsValue(Object value) {
        Enumeration<K> attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            K attrName = attrNames.nextElement();
            V attrValue = this.getAttribute(attrName);
            boolean bl = value == null ? attrValue == null : value.equals(attrValue);
            boolean found = bl;
            if (!found) continue;
            return true;
        }
        return false;
    }

    public synchronized Map<K, V> getDelegateMap() {
        HashMap<K, V> result = new HashMap<K, V>();
        Enumeration<K> attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            K attrName = attrNames.nextElement();
            result.put(attrName, this.getAttribute(attrName));
        }
        return Collections.unmodifiableMap(result);
    }
}

