/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nablarch.core.util.map.MapWrapper;

public class CopyOnReadMap<K, V>
extends MapWrapper<K, V> {
    private final Map<K, V> baseMap;
    private boolean active = true;
    private K[] ignoredEntries = new Object[0];
    private final ThreadLocal<Snapshot<K, V>> snapshotOnCurrentThread = new ThreadLocal<Snapshot<K, V>>(){

        @Override
        protected Snapshot<K, V> initialValue() {
            return null;
        }
    };

    public CopyOnReadMap() {
        this(new ConcurrentHashMap());
    }

    public CopyOnReadMap(Map<K, V> baseMap) {
        this.baseMap = baseMap;
    }

    public Map<K, V> getDelegateMap() throws SnapshotCreationError {
        if (!this.active) {
            return this.baseMap;
        }
        return this.getSnapshot();
    }

    public CopyOnReadMap<K, V> deactivate() {
        this.active = false;
        return this;
    }

    public CopyOnReadMap<K, V> setIgnoredEntries(K ... entryNames) {
        this.ignoredEntries = entryNames;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyOnReadMap<K, V> save() throws ConcurrentModificationException, SnapshotCreationError {
        try {
            Snapshot<K, V> snapshot = this.snapshotOnCurrentThread.get();
            if (snapshot == null) {
                CopyOnReadMap copyOnReadMap = this;
                return copyOnReadMap;
            }
            Map<K, V> map = this.baseMap;
            synchronized (map) {
                ((Snapshot)snapshot).flush();
            }
        }
        finally {
            this.refresh();
        }
        return this;
    }

    public void refresh() {
        this.snapshotOnCurrentThread.remove();
    }

    private Snapshot<K, V> getSnapshot() {
        if (this.snapshotOnCurrentThread.get() == null) {
            this.snapshotOnCurrentThread.set(Snapshot.take(this.baseMap, this.ignoredEntries));
        }
        return this.snapshotOnCurrentThread.get();
    }

    public static class SnapshotCreationError
    extends IllegalStateException {
        public SnapshotCreationError(Throwable e) {
            super("unable to create snapshot of this map.", e);
        }
    }

    private static final class Snapshot<K, V>
    extends HashMap<K, V> {
        private transient byte[] digest = new byte[16];
        private transient Map<K, V> original;
        private transient K[] ignoredEntries = new Object[0];

        private Snapshot() {
        }

        private static <K, V> Snapshot<K, V> take(Map<K, V> original, K[] ignoredEntries) {
            Snapshot<K, V> snapshot = new Snapshot<K, V>();
            snapshot.putAll(original);
            for (K ignored : ignoredEntries) {
                snapshot.remove(ignored);
            }
            byte[] serialized = Snapshot.serialize(snapshot);
            Snapshot clone = null;
            try {
                clone = (Snapshot)new ObjectInputStream(new ByteArrayInputStream(serialized)).readObject();
                clone.original = original;
                clone.digest = new byte[16];
                clone.ignoredEntries = ignoredEntries;
                System.arraycopy(Snapshot.calcDigest(serialized), 0, clone.digest, 0, 16);
                return clone;
            }
            catch (IOException e) {
                throw new SnapshotCreationError(e);
            }
            catch (ClassNotFoundException e) {
                throw new SnapshotCreationError(e);
            }
        }

        private boolean isDirty() {
            byte[] currentDigest = Snapshot.take(this, this.ignoredEntries).digest;
            return !MessageDigest.isEqual(this.digest, currentDigest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush() throws ConcurrentModificationException {
            Map<K, V> map = this.original;
            synchronized (map) {
                if (!this.isDirty()) {
                    return;
                }
                byte[] currentDigest = Snapshot.take(this.original, this.ignoredEntries).digest;
                if (!MessageDigest.isEqual(this.digest, currentDigest)) {
                    throw new ConcurrentModificationException("this map was touched concurrently.");
                }
                HashMap<K, V> reserved = new HashMap<K, V>();
                for (K ignored : this.ignoredEntries) {
                    V value = this.original.get(ignored);
                    if (value == null) continue;
                    reserved.put(ignored, value);
                }
                this.original.clear();
                this.original.putAll(reserved);
                this.original.putAll(this);
            }
        }

        private static byte[] calcDigest(byte[] data) {
            try {
                return MessageDigest.getInstance("MD5").digest(data);
            }
            catch (NoSuchAlgorithmException wontHappen) {
                throw new RuntimeException(wontHappen);
            }
        }

        private static byte[] serialize(Object obj) throws SnapshotCreationError {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream objWriter = new ObjectOutputStream(byteStream);
                objWriter.writeObject(obj);
                objWriter.close();
                return byteStream.toByteArray();
            }
            catch (IOException e) {
                throw new SnapshotCreationError(e);
            }
        }
    }
}

