/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import nablarch.core.util.map.LockableMap;

public class ExclusiveAccessMap<K, V>
extends LockableMap<K, V> {
    public ExclusiveAccessMap(Map<K, V> baseMap) {
        super(baseMap);
    }

    public ExclusiveAccessMap(Map<K, V> baseMap, ReentrantLock lock) {
        super(baseMap, lock);
    }

    public void clear() {
        this.lock();
        super.clear();
    }

    public boolean containsKey(Object key) {
        this.lock();
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.lock();
        return super.containsValue(value);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.lock();
        return super.entrySet();
    }

    public V get(Object key) {
        this.lock();
        return (V)super.get(key);
    }

    public boolean isEmpty() {
        this.lock();
        return super.isEmpty();
    }

    public Set<K> keySet() {
        this.lock();
        return super.keySet();
    }

    public V put(K key, V value) {
        this.lock();
        return (V)super.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock();
        super.putAll(m);
    }

    public V remove(Object key) {
        this.lock();
        return (V)super.remove(key);
    }

    public int size() {
        this.lock();
        return super.size();
    }

    public Collection<V> values() {
        this.lock();
        return super.values();
    }
}

