/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util.map;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nablarch.core.util.map.MapWrapper;

public class LockableMap<K, V>
extends MapWrapper<K, V>
implements Lock {
    private final Map<K, V> baseMap;
    private final ReentrantLock lock;
    private boolean active = true;

    public LockableMap(Map<K, V> baseMap) {
        this(baseMap, new ReentrantLock());
    }

    public LockableMap(Map<K, V> baseMap, ReentrantLock lock) {
        this.baseMap = baseMap;
        this.lock = lock;
    }

    public Map<K, V> getDelegateMap() {
        return this.baseMap;
    }

    @Override
    public void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    @Override
    public void lock() {
        if (!this.lock.isHeldByCurrentThread() && this.active) {
            this.lock.lock();
        }
    }

    public void deactivate() {
        this.unlock();
        this.active = false;
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("ExclusiveAccessMap#lockInterruptibly has not supported yet.");
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("ExclusiveAccessMap#newCondition has not supported yet.");
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException("ExclusiveAccessMap#tryLock has not supported yet.");
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        throw new UnsupportedOperationException("ExclusiveAccessMap#tryLock has not supported yet.");
    }
}

