/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import nablarch.core.util.annotation.Published;
import nablarch.core.util.map.MapWrapper;

@Published(tag={"architect"})
public class HttpCookie
extends MapWrapper<String, String> {
    private static final Method IS_HTTP_ONLY_METHOD;
    private static final Method SET_HTTP_ONLY_METHOD;
    private final Map<String, String> cookies = new HashMap<String, String>();
    private Integer maxAge;
    private String path;
    private String domain;
    private boolean secure;
    private boolean httpOnly;

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public HttpCookie setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public HttpCookie setPath(String path) {
        this.path = path;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public HttpCookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public HttpCookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isHttpOnly() {
        if (IS_HTTP_ONLY_METHOD == null) {
            throw new UnsupportedOperationException("ServletAPI in use is unsupported the HttpOnly attribute. Please update version of ServletAPI to 3.0 or more.");
        }
        return this.httpOnly;
    }

    public HttpCookie setHttpOnly(boolean httpOnly) {
        if (SET_HTTP_ONLY_METHOD == null) {
            throw new UnsupportedOperationException("ServletAPI in use is unsupported the HttpOnly attribute. Please update version of ServletAPI to 3.0 or more.");
        }
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean supportsHttpOnly() {
        return SET_HTTP_ONLY_METHOD != null;
    }

    public List<Cookie> convertServletCookies() {
        ArrayList<Cookie> servletCookies = new ArrayList<Cookie>();
        for (Map.Entry<String, String> entry : this.getDelegateMap().entrySet()) {
            Cookie servletCookie = new Cookie(entry.getKey(), entry.getValue());
            if (this.getMaxAge() != null) {
                servletCookie.setMaxAge(this.getMaxAge().intValue());
            }
            if (this.getPath() != null) {
                servletCookie.setPath(this.getPath());
            }
            if (this.getDomain() != null) {
                servletCookie.setDomain(this.getDomain());
            }
            servletCookie.setSecure(this.isSecure());
            if (SET_HTTP_ONLY_METHOD != null) {
                try {
                    SET_HTTP_ONLY_METHOD.invoke((Object)servletCookie, this.isHttpOnly());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            servletCookies.add(servletCookie);
        }
        return servletCookies;
    }

    public Map<String, String> getDelegateMap() {
        return this.cookies;
    }

    static {
        Method isHttpOnlyMethod = null;
        try {
            isHttpOnlyMethod = Cookie.class.getMethod("isHttpOnly", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        IS_HTTP_ONLY_METHOD = isHttpOnlyMethod;
        Method setHttpOnlyMethod = null;
        try {
            setHttpOnlyMethod = Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SET_HTTP_ONLY_METHOD = setHttpOnlyMethod;
    }
}

