/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.log.LogUtil;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.Builder;
import nablarch.fw.ExecutionContext;
import nablarch.fw.HandlerWrapper;
import nablarch.fw.MethodBinder;
import nablarch.fw.handler.MethodBinding;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;

public class HttpMethodBinding
extends MethodBinding<HttpRequest, HttpResponse>
implements HttpRequestHandler {
    private static final Logger DEV_LOGGER = LoggerManager.get((String)"DEV");
    private static final Pattern DEV_LOG_EXCLUDES = Pattern.compile(".*nablarch_.*");
    private static final Pattern RESOURCE_NAME_IN_URI = Pattern.compile("/([^/]*?)/?$");

    public HttpMethodBinding(Object delegate) {
        super(delegate);
    }

    protected Method getMethodBoundTo(HttpRequest req, ExecutionContext ctx) {
        Matcher m = RESOURCE_NAME_IN_URI.matcher(req.getRequestPath());
        String resourceName = m.find() ? m.group(1) : "";
        String methodName = (req.getMethod() + resourceName).toLowerCase().replaceAll("[^0-9a-zA-Z]", "").trim();
        Method result = this.getHandleMethod(methodName);
        if (result == null) {
            methodName = methodName.replaceFirst("^get|^post", "do");
            result = this.getHandleMethod(methodName);
        }
        if (DEV_LOGGER.isDebugEnabled()) {
            String delegateClassName = this.getDelegates(req, ctx).get(0).getClass().getName();
            String msg = result != null ? Builder.concat((Object[])new Object[]{"**** DISPATCHING METHOD **** method = [", delegateClassName, "#", result.getName(), "]"}) : Builder.concat((Object[])new Object[]{"**** DISPATCHING METHOD **** method not found. class = [", delegateClassName, "],", " method signature = [HttpResponse ", methodName, "(HttpRequest, ExecutionContext)]"});
            DEV_LOGGER.logDebug(msg, new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
        HttpResponse httpResponse;
        if (DEV_LOGGER.isDebugEnabled()) {
            String separator = Logger.LS + "\t\t";
            DEV_LOGGER.logDebug(Builder.concat((Object[])new Object[]{"**** BEFORE ACTION ****", Logger.LS, "\t", "request_parameter = [", LogUtil.dumpMap(req.getParamMap(), (String)separator), "]", Logger.LS, "\t", "request_scope = [", LogUtil.dumpMap((Map)ctx.getRequestScopeMap(), (String)separator, (Pattern)DEV_LOG_EXCLUDES), "]", Logger.LS, "\t", "session_scope = [", LogUtil.dumpMap((Map)ctx.getSessionScopeMap(), (String)separator, (Pattern)DEV_LOG_EXCLUDES), "]"}), new Object[0]);
        }
        try {
            httpResponse = (HttpResponse)super.handle((Object)req, ctx);
        }
        catch (Throwable throwable) {
            if (DEV_LOGGER.isDebugEnabled()) {
                String separator = Logger.LS + "\t\t";
                DEV_LOGGER.logDebug(Builder.concat((Object[])new Object[]{"**** AFTER ACTION ****", Logger.LS, "\t", "request_parameter = [", LogUtil.dumpMap(req.getParamMap(), (String)separator), "]", Logger.LS, "\t", "request_scope = [", LogUtil.dumpMap((Map)ctx.getRequestScopeMap(), (String)separator, (Pattern)DEV_LOG_EXCLUDES), "]", Logger.LS, "\t", "session_scope = [", LogUtil.dumpMap((Map)ctx.getSessionScopeMap(), (String)separator, (Pattern)DEV_LOG_EXCLUDES), "]"}), new Object[0]);
            }
            throw throwable;
        }
        if (DEV_LOGGER.isDebugEnabled()) {
            String separator = Logger.LS + "\t\t";
            DEV_LOGGER.logDebug(Builder.concat((Object[])new Object[]{"**** AFTER ACTION ****", Logger.LS, "\t", "request_parameter = [", LogUtil.dumpMap(req.getParamMap(), (String)separator), "]", Logger.LS, "\t", "request_scope = [", LogUtil.dumpMap((Map)ctx.getRequestScopeMap(), (String)separator, (Pattern)DEV_LOG_EXCLUDES), "]", Logger.LS, "\t", "session_scope = [", LogUtil.dumpMap((Map)ctx.getSessionScopeMap(), (String)separator, (Pattern)DEV_LOG_EXCLUDES), "]"}), new Object[0]);
        }
        return httpResponse;
    }

    public static class Binder
    implements MethodBinder<HttpRequest, HttpResponse> {
        public HandlerWrapper<HttpRequest, HttpResponse> bind(Object delegate) {
            return new HttpMethodBinding(delegate);
        }
    }
}

