/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;
import nablarch.core.validation.Validatable;
import nablarch.fw.Request;
import nablarch.fw.web.HttpCookie;
import nablarch.fw.web.upload.PartInfo;
import nablarch.fw.web.useragent.UserAgent;
import nablarch.fw.web.useragent.UserAgentParser;

public abstract class HttpRequest
implements Request<String[]>,
Validatable<String[]> {
    private static final UserAgentParser DEFAULT_USER_AGENT_PARSER = new UserAgentParser(){

        @Override
        public UserAgent parse(String userAgentText) {
            return new UserAgent(userAgentText);
        }
    };
    private String requestUri;
    private Map<String, List<PartInfo>> multipart = Collections.emptyMap();

    @Published
    public abstract String getMethod();

    @Published
    public String getRequestUri() {
        return this.requestUri;
    }

    public HttpRequest setRequestUri(String requestUri) {
        this.requestUri = requestUri.trim();
        return this;
    }

    @Published
    public String getRequestPath() {
        return this.requestUri.replaceFirst("[?;].*$", "");
    }

    @Published(tag={"architect"})
    public HttpRequest setRequestPath(String requestPath) {
        String dollarEscaped = requestPath.replace("$", "\\$");
        String uri = this.requestUri.replaceFirst("^(.+?)(\\?[^?]*)?$", dollarEscaped + "$2");
        this.setRequestUri(uri);
        return this;
    }

    @Published
    public abstract String getHttpVersion();

    public abstract Map<String, String[]> getParamMap();

    public abstract String[] getParam(String var1);

    @Published
    public abstract HttpRequest setParam(String var1, String ... var2);

    @Published(tag={"architect"})
    public abstract HttpRequest setParamMap(Map<String, String[]> var1);

    @Published
    public abstract Map<String, String> getHeaderMap();

    @Published
    public abstract String getHeader(String var1);

    @Published
    public String getHost() {
        return this.getHeader("Host");
    }

    @Published(tag={"architect"})
    public abstract HttpCookie getCookie();

    @Published
    public List<PartInfo> getPart(String name) {
        List<PartInfo> list = this.multipart.get(name);
        return list == null ? Collections.emptyList() : list;
    }

    @Published(tag={"architect"})
    public void setMultipart(Map<String, List<PartInfo>> multipart) {
        if (multipart == null) {
            multipart = Collections.emptyMap();
        }
        this.multipart = multipart;
    }

    @Published
    public Map<String, List<PartInfo>> getMultipart() {
        return this.multipart;
    }

    @Published
    public <UA extends UserAgent> UA getUserAgent() {
        String userAgentText = this.getHeader("User-Agent");
        UserAgentParser parser = this.getUserAgentParser();
        return (UA)parser.parse(userAgentText);
    }

    private UserAgentParser getUserAgentParser() {
        UserAgentParser registered = (UserAgentParser)SystemRepository.get((String)"userAgentParser");
        return registered != null ? registered : DEFAULT_USER_AGENT_PARSER;
    }
}

