/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.ResourceLocatorInternalHelper;

@Published
public final class ResourceLocator {
    private static final Logger LOG = LoggerManager.get(ResourceLocator.class);
    private static final String DEFAULT_SCHEME = "servlet";
    public static final String SCHEMES = "file|classpath|forward|servlet|redirect|https|http";
    private static final Pattern ALLOWED_SCHEMES = Pattern.compile("^file|classpath|forward|servlet|redirect|https|http$");
    private static final Pattern EXTRACT_SCHEME_PATTERN = Pattern.compile("^(?:(.+)://)");
    private static final Pattern EXTRACT_HOSTNAME_PATTERN = Pattern.compile("^([^/?#]+)");
    public static final Pattern ALLOWED_CHAR = Pattern.compile("^([^./~]|\\.(?=[^.]))*/$");
    private final String contentPath;
    private final String scheme;
    private final String path;
    private final String resourceName;
    private final String hostname;
    private final String directory;
    private final boolean redirectWithAbsoluteUri;

    public static ResourceLocator valueOf(String path) {
        return new ResourceLocator(path);
    }

    private ResourceLocator(String path) {
        Resource resource;
        String pathWithoutScheme;
        if (path.startsWith("redirect:") && !path.startsWith("redirect://")) {
            String maybeAbsoluteUri = path.substring("redirect:".length());
            if (!ResourceLocatorInternalHelper.startsWithScheme(maybeAbsoluteUri)) {
                throw ResourceLocator.createResponseForMalformedResourcePath(path);
            }
            this.contentPath = path;
            this.scheme = "redirect";
            this.path = maybeAbsoluteUri;
            this.resourceName = "";
            this.hostname = "";
            this.directory = "";
            this.redirectWithAbsoluteUri = true;
            return;
        }
        this.redirectWithAbsoluteUri = false;
        Matcher matcher = EXTRACT_SCHEME_PATTERN.matcher(path);
        if (matcher.find()) {
            this.scheme = matcher.group(1);
            if (!ALLOWED_SCHEMES.matcher(this.scheme).matches()) {
                throw ResourceLocator.createResponseForMalformedResourcePath(path);
            }
            pathWithoutScheme = path.substring(matcher.end());
            this.contentPath = path;
        } else {
            pathWithoutScheme = path;
            this.scheme = DEFAULT_SCHEME;
            this.contentPath = "servlet://" + path;
        }
        if (this.isHttpScheme()) {
            Matcher hostnameMatcher = EXTRACT_HOSTNAME_PATTERN.matcher(pathWithoutScheme);
            if (hostnameMatcher.find()) {
                resource = new Resource(pathWithoutScheme.substring(hostnameMatcher.end()));
                this.hostname = hostnameMatcher.group(1);
            } else {
                resource = new Resource("");
                this.hostname = "";
            }
        } else {
            resource = new Resource(pathWithoutScheme);
            this.hostname = "";
        }
        this.path = resource.getDirectory() + resource.getResourceName();
        this.directory = resource.getDirectory();
        this.resourceName = resource.getResourceName();
    }

    boolean isRedirectWithAbsoluteUri() {
        return this.redirectWithAbsoluteUri;
    }

    private boolean isHttpScheme() {
        return this.scheme.equals("https") || this.scheme.equals("http");
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isRelative() {
        if (this.scheme.equals("classpath") || this.isHttpScheme() || this.redirectWithAbsoluteUri) {
            return false;
        }
        return !this.path.startsWith("/");
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.contentPath;
    }

    public String getRealPath() throws UnsupportedOperationException {
        if (this.scheme.equals("file")) {
            return new File(this.getPath()).getAbsolutePath();
        }
        if (this.scheme.equals("classpath")) {
            URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(this.getPath().replaceFirst("^/", ""));
            return resourceUrl != null ? resourceUrl.toExternalForm().replaceFirst("file:", "") : null;
        }
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        if (this.scheme.equals(DEFAULT_SCHEME) || this.scheme.equals("forward")) {
            return true;
        }
        if (this.scheme.equals("redirect") || this.scheme.equals("http") || this.scheme.equals("https")) {
            return false;
        }
        String path = this.getRealPath();
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    public Reader getReader() throws FileNotFoundException {
        if (this.scheme.equals("file") || this.scheme.equals("classpath")) {
            String path = this.getRealPath();
            if (path == null) {
                throw new FileNotFoundException(this.toString());
            }
            return new FileReader(path);
        }
        throw new FileNotFoundException(this.toString());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.scheme.equals("file") || this.scheme.equals("classpath")) {
            String path = this.getRealPath();
            if (path == null) {
                throw new FileNotFoundException(this.toString());
            }
            return new FileInputStream(path);
        }
        throw new FileNotFoundException(this.toString());
    }

    public boolean isRedirect() {
        return this.scheme.matches("redirect|https?");
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDirectory() {
        return this.directory;
    }

    private static HttpErrorResponse createResponseForMalformedResourcePath(String path) {
        LOG.logInfo("malformed resource path. resource path = " + path, new Object[0]);
        return new HttpErrorResponse(400);
    }

    private static class Resource {
        private final String directory;
        private final String resourceName;

        public Resource(String path) {
            int last = path.lastIndexOf(47);
            if (last != -1) {
                this.directory = path.substring(0, last + 1);
                this.resourceName = path.substring(last + 1);
            } else {
                this.directory = "";
                this.resourceName = path;
            }
            for (String s : this.directory.split("/")) {
                if (ALLOWED_CHAR.matcher(s + '/').matches()) continue;
                throw ResourceLocator.createResponseForMalformedResourcePath(path);
            }
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

