/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.fw.web.download.encorder.UrlDownloadFileNameEncoder;

class ContentDispositionRawValue {
    private static final String FILENAME_PARAM_NAME = ContentDispositionRawValue.normalizeKey("filename");
    private static final String FILENAME_EXT_PARAM_NAME = ContentDispositionRawValue.normalizeKey("filename*");
    private static final Pattern TYPE_PATTERN = Pattern.compile("\\s*([^;\\s]+)");
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\s*;\\s*([^=\\s]+)\\s*=\\s*([^;\\s]+)");
    private static final UrlDownloadFileNameEncoder UTF8_URL_ENCODER = new UrlDownloadFileNameEncoder();
    private final String type;
    private final List<Param> params;
    private final Param filenameParam;
    private final boolean containsFilenameExtParam;

    public ContentDispositionRawValue(String rawValue) {
        Matcher typeMatcher = TYPE_PATTERN.matcher(rawValue);
        typeMatcher.find();
        this.type = typeMatcher.group(1);
        int index = typeMatcher.group().length();
        LinkedHashMap<String, Param> paramMap = new LinkedHashMap<String, Param>();
        Matcher paramMatcher = PARAM_PATTERN.matcher(rawValue);
        while (paramMatcher.find(index)) {
            String key = paramMatcher.group(1);
            String value = paramMatcher.group(2);
            Param param = new Param(key, value);
            param.putTo(paramMap);
            index += paramMatcher.group().length();
        }
        this.params = new ArrayList(paramMap.values());
        this.filenameParam = (Param)paramMap.get(FILENAME_PARAM_NAME);
        this.containsFilenameExtParam = paramMap.containsKey(FILENAME_EXT_PARAM_NAME);
    }

    public boolean needsToBeEncoded() {
        return this.filenameParam != null && this.filenameParam.quoted;
    }

    public String getRawFileName() {
        return this.filenameParam.value;
    }

    public String buildEncodedValue(String encodedFileName) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type);
        for (Param param : this.params) {
            param.appendTo(buf, encodedFileName);
        }
        return buf.toString();
    }

    private static String normalizeKey(String key) {
        return key.toLowerCase();
    }

    private class Param {
        final String originalKey;
        final String normalizedKey;
        final String value;
        final boolean quoted;

        Param(String key, String value) {
            this.originalKey = key;
            this.normalizedKey = ContentDispositionRawValue.normalizeKey(key);
            if (value.charAt(0) == '\"') {
                this.value = value.substring(1, value.length() - 1);
                this.quoted = true;
            } else {
                this.value = value;
                this.quoted = false;
            }
        }

        void appendTo(StringBuilder buf, String encodedFileName) {
            boolean isFilenameParam = this.normalizedKey.equals(FILENAME_PARAM_NAME);
            if (isFilenameParam && !ContentDispositionRawValue.this.containsFilenameExtParam) {
                buf.append("; ").append(FILENAME_EXT_PARAM_NAME).append('=').append("UTF-8''").append(UTF8_URL_ENCODER.encode(this.value));
            }
            buf.append("; ").append(this.originalKey).append('=');
            if (this.quoted) {
                buf.append('\"');
            }
            buf.append(isFilenameParam ? encodedFileName : this.value);
            if (this.quoted) {
                buf.append('\"');
            }
        }

        void putTo(LinkedHashMap<String, Param> paramMap) {
            paramMap.put(this.normalizedKey, this);
        }
    }
}

