/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import nablarch.common.web.WebConfig;
import nablarch.common.web.WebConfigFinder;
import nablarch.common.web.session.SessionUtil;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.csrf.BadRequestVerificationFailureHandler;
import nablarch.fw.web.handler.csrf.CsrfTokenGenerator;
import nablarch.fw.web.handler.csrf.HttpMethodVerificationTargetMatcher;
import nablarch.fw.web.handler.csrf.UUIDv4CsrfTokenGenerator;
import nablarch.fw.web.handler.csrf.VerificationFailureHandler;
import nablarch.fw.web.handler.csrf.VerificationTargetMatcher;

public class CsrfTokenVerificationHandler
implements HttpRequestHandler {
    public static final String REQUEST_REGENERATE_KEY = "nablarch_request_for_csrf_token_to_be_regenerated";
    private static final Logger LOGGER = LoggerManager.get(CsrfTokenVerificationHandler.class);
    private CsrfTokenGenerator csrfTokenGenerator = new UUIDv4CsrfTokenGenerator();
    private VerificationTargetMatcher verificationTargetMatcher = new HttpMethodVerificationTargetMatcher();
    private VerificationFailureHandler verificationFailureHandler = new BadRequestVerificationFailureHandler();

    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        String userSentToken;
        String sessionAssociatedToken = this.getSessionAssociatedToken(context);
        if (this.isTargetOfVerification(request) && !this.verifyToken(userSentToken = this.getUserSentToken(request), sessionAssociatedToken)) {
            return this.verificationFailureHandler.handle(request, context, userSentToken, sessionAssociatedToken);
        }
        HttpResponse response = (HttpResponse)context.handleNext((Object)request);
        Object requestToRegenerate = context.getRequestScopedVar(REQUEST_REGENERATE_KEY);
        if (requestToRegenerate != null) {
            if (Boolean.TRUE.equals(requestToRegenerate)) {
                this.generateAndSaveToken(context);
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.logWarn("A request scoped variable named 'nablarch_request_for_csrf_token_to_be_regenerated' has unexpected value. 'nablarch_request_for_csrf_token_to_be_regenerated' must be Bolean.TRUE.", new Object[0]);
            }
        }
        return response;
    }

    private boolean isTargetOfVerification(HttpRequest request) {
        return this.verificationTargetMatcher.match(request);
    }

    private boolean verifyToken(String userSentToken, String sessionAssociatedToken) {
        return userSentToken != null && userSentToken.equals(sessionAssociatedToken);
    }

    private String getUserSentToken(HttpRequest request) {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        String header = request.getHeader(webConfig.getCsrfTokenHeaderName());
        if (header != null) {
            return header;
        }
        String[] params = request.getParam(webConfig.getCsrfTokenParameterName());
        if (params != null && params.length > 0) {
            return params[0];
        }
        return null;
    }

    private String getSessionAssociatedToken(ExecutionContext context) {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        String name = webConfig.getCsrfTokenSessionStoredVarName();
        String csrfToken = (String)SessionUtil.orNull(context, name);
        if (csrfToken == null) {
            csrfToken = this.generateAndSaveToken(context);
        }
        return csrfToken;
    }

    private String generateAndSaveToken(ExecutionContext context) {
        WebConfig webConfig = WebConfigFinder.getWebConfig();
        String name = webConfig.getCsrfTokenSessionStoredVarName();
        String csrfToken = this.csrfTokenGenerator.generateToken();
        String storeName = webConfig.getCsrfTokenSavedStoreName();
        if (storeName != null) {
            SessionUtil.put(context, name, csrfToken, storeName);
        } else {
            SessionUtil.put(context, name, csrfToken);
        }
        return csrfToken;
    }

    public void setCsrfTokenGenerator(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    public void setVerificationTargetMatcher(VerificationTargetMatcher verificationTargetMatcher) {
        this.verificationTargetMatcher = verificationTargetMatcher;
    }

    public void setVerificationFailureHandler(VerificationFailureHandler verificationFailureHandler) {
        this.verificationFailureHandler = verificationFailureHandler;
    }
}

