/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.ArrayList;
import nablarch.common.util.WebRequestUtil;
import nablarch.core.ThreadContext;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResourceLocator;

public class ForwardingHandler
implements HttpRequestHandler {
    @Override
    public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
        ArrayList<ForwardingHandler> snapshot = new ArrayList<ForwardingHandler>();
        snapshot.add(this);
        snapshot.addAll(ctx.getHandlerQueue());
        HttpResponse res = (HttpResponse)ctx.handleNext((Object)req);
        if (this.needsForwarding(res)) {
            ctx.getHandlerQueue().clear();
            ctx.getHandlerQueue().addAll(snapshot);
            res = this.doForwarding(res, req, ctx);
        }
        return res;
    }

    private boolean needsForwarding(HttpResponse res) {
        ResourceLocator contentPath = res.getContentPath();
        return contentPath != null && contentPath.getScheme().equals("forward");
    }

    private HttpResponse doForwarding(HttpResponse res, HttpRequest req, ExecutionContext ctx) {
        ResourceLocator path = res.getContentPath();
        String uri = path.isRelative() ? req.getRequestUri().replaceAll("/[^/]*$", "/" + path.getPath()) : path.getPath();
        int currentStatus = res.getStatusCode();
        req.setRequestUri(uri);
        ThreadContext.setInternalRequestId((String)WebRequestUtil.getRequestId(req.getRequestPath()));
        res = (HttpResponse)ctx.handleNext((Object)req);
        if (currentStatus > res.getStatusCode()) {
            res.setStatusCode(currentStatus);
        }
        return res;
    }
}

