/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.health.HealthCheckResponseBuilder;
import nablarch.fw.web.handler.health.HealthCheckResult;
import nablarch.fw.web.handler.health.HealthChecker;

public class HealthCheckEndpointHandler
implements HttpRequestHandler {
    private List<HealthChecker> healthCheckers = Collections.emptyList();
    private HealthCheckResponseBuilder healthCheckResponseBuilder = new HealthCheckResponseBuilder();

    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        boolean isMergedHealthy = true;
        ArrayList<HealthCheckResult.Target> targets = new ArrayList<HealthCheckResult.Target>();
        for (HealthChecker healthChecker : this.healthCheckers) {
            boolean isHealthy = healthChecker.check(request, context);
            isMergedHealthy = isMergedHealthy && isHealthy;
            targets.add(new HealthCheckResult.Target(healthChecker.getName(), isHealthy));
        }
        return this.healthCheckResponseBuilder.build(request, context, new HealthCheckResult(isMergedHealthy, targets));
    }

    public void setHealthCheckers(List<HealthChecker> healthCheckers) {
        this.healthCheckers = healthCheckers;
    }

    public void setHealthCheckResponseBuilder(HealthCheckResponseBuilder healthCheckResponseBuilder) {
        this.healthCheckResponseBuilder = healthCheckResponseBuilder;
    }
}

