/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nablarch.core.ThreadContext;
import nablarch.core.log.DateItemSupport;
import nablarch.core.log.LogItem;
import nablarch.core.log.LogUtil;
import nablarch.core.log.Logger;
import nablarch.core.log.MaskingMapItemSupport;
import nablarch.core.log.app.AppLogUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResourceLocator;
import nablarch.fw.web.handler.HttpResponseUtil;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public class HttpAccessLogFormatter {
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String DEFAULT_BEGIN_FORMAT = "@@@@ BEGIN @@@@ rid = [$requestId$] uid = [$userId$] sid = [$sessionId$]\n\turl         = [$url$]\n\tmethod      = [$method$]\n\tport        = [$port$]\n\tclient_ip   = [$clientIpAddress$]\n\tclient_host = [$clientHost$]";
    private static final String DEFAULT_PARAMETERS_FORMAT = "@@@@ PARAMETERS @@@@\n\tparameters  = [$parameters$]";
    private static final String DEFAULT_DISPATCHING_CLASS_FORMAT = "@@@@ DISPATCHING CLASS @@@@ class = [$dispatchingClass$]";
    private static final String DEFAULT_END_FORMAT = "@@@@ END @@@@ rid = [$requestId$] uid = [$userId$] sid = [$sessionId$] url = [$url$] status_code = [$statusCode$] content_path = [$contentPath$]\n\tstart_time     = [$startTime$]\n\tend_time       = [$endTime$]\n\texecution_time = [$executionTime$]\n\tmax_memory     = [$maxMemory$]\n\tfree_memory    = [$freeMemory$]";
    private static final String DEFAULT_MASKING_CHAR = "*";
    private static final Pattern[] DEFAULT_MASKING_PATTERNS = new Pattern[0];
    private static final String DEFAULT_PARAMETERS_SEPARATOR = Logger.LS + "\t\t";
    private static final String DEFAULT_SESSION_SCOPE_SEPARATOR = Logger.LS + "\t\t";
    private static final String DEFAULT_BEGIN_OUTPUT_ENABLED = Boolean.TRUE.toString();
    private static final String DEFAULT_PARAMETERS_OUTPUT_ENABLED = Boolean.TRUE.toString();
    private static final String DEFAULT_DISPATCHING_CLASS_OUTPUT_ENABLED = Boolean.TRUE.toString();
    private static final String DEFAULT_END_OUTPUT_ENABLED = Boolean.TRUE.toString();
    public static final String PROPS_PREFIX = "httpAccessLogFormatter.";
    private static final String PROPS_BEGIN_FORMAT = "httpAccessLogFormatter.beginFormat";
    private static final String PROPS_PARAMETERS_FORMAT = "httpAccessLogFormatter.parametersFormat";
    private static final String PROPS_DISPATCHING_CLASS_FORMAT = "httpAccessLogFormatter.dispatchingClassFormat";
    private static final String PROPS_END_FORMAT = "httpAccessLogFormatter.endFormat";
    private static final String PROPS_DATE_PATTERN = "httpAccessLogFormatter.datePattern";
    private static final String PROPS_MASKING_CHAR = "httpAccessLogFormatter.maskingChar";
    private static final String PROPS_MASKING_PATTERNS = "httpAccessLogFormatter.maskingPatterns";
    private static final String PROPS_PARAMETERS_SEPARATOR = "httpAccessLogFormatter.parametersSeparator";
    private static final String PROPS_SESSION_SCOPE_SEPARATOR = "httpAccessLogFormatter.sessionScopeSeparator";
    private static final String PROPS_BEGIN_OUTPUT_ENABLED = "httpAccessLogFormatter.beginOutputEnabled";
    private static final String PROPS_PARAMETERS_OUTPUT_ENABLED = "httpAccessLogFormatter.parametersOutputEnabled";
    private static final String PROPS_DISPATCHING_CLASS_OUTPUT_ENABLED = "httpAccessLogFormatter.dispatchingClassOutputEnabled";
    private static final String PROPS_END_OUTPUT_ENABLED = "httpAccessLogFormatter.endOutputEnabled";
    private boolean beginOutputEnabled;
    private boolean parametersOutputEnabled;
    private boolean dispatchingClassOutputEnabled;
    private boolean endOutputEnabled;
    private boolean containsMemoryItem = false;
    private LogItem<HttpAccessLogContext>[] beginLogItems;
    private LogItem<HttpAccessLogContext>[] parametersLogItems;
    private LogItem<HttpAccessLogContext>[] dispatchingClassLogItems;
    private LogItem<HttpAccessLogContext>[] endLogItems;
    private static final Pattern MULTIVALUE_SEPARATOR_PATTERN = Pattern.compile(",");

    public HttpAccessLogFormatter() {
        Map props = AppLogUtil.getProps();
        Map<String, LogItem<HttpAccessLogContext>> logItems = this.getLogItems(props);
        this.beginOutputEnabled = Boolean.valueOf(this.getProp(props, PROPS_BEGIN_OUTPUT_ENABLED, DEFAULT_BEGIN_OUTPUT_ENABLED));
        if (this.beginOutputEnabled) {
            this.beginLogItems = LogUtil.createFormattedLogItems(logItems, (String)this.getProp(props, PROPS_BEGIN_FORMAT, DEFAULT_BEGIN_FORMAT));
        }
        this.parametersOutputEnabled = Boolean.valueOf(this.getProp(props, PROPS_PARAMETERS_OUTPUT_ENABLED, DEFAULT_PARAMETERS_OUTPUT_ENABLED));
        if (this.parametersOutputEnabled) {
            this.parametersLogItems = LogUtil.createFormattedLogItems(logItems, (String)this.getProp(props, PROPS_PARAMETERS_FORMAT, DEFAULT_PARAMETERS_FORMAT));
        }
        this.dispatchingClassOutputEnabled = Boolean.valueOf(this.getProp(props, PROPS_DISPATCHING_CLASS_OUTPUT_ENABLED, DEFAULT_DISPATCHING_CLASS_OUTPUT_ENABLED));
        if (this.dispatchingClassOutputEnabled) {
            this.dispatchingClassLogItems = LogUtil.createFormattedLogItems(logItems, (String)this.getProp(props, PROPS_DISPATCHING_CLASS_FORMAT, DEFAULT_DISPATCHING_CLASS_FORMAT));
        }
        this.endOutputEnabled = Boolean.valueOf(this.getProp(props, PROPS_END_OUTPUT_ENABLED, DEFAULT_END_OUTPUT_ENABLED));
        if (this.endOutputEnabled) {
            this.endLogItems = LogUtil.createFormattedLogItems(logItems, (String)this.getProp(props, PROPS_END_FORMAT, DEFAULT_END_FORMAT));
            this.containsMemoryItem = LogUtil.contains(this.endLogItems, (Class[])new Class[]{MaxMemoryItem.class, FreeMemoryItem.class});
        }
    }

    public HttpAccessLogContext createAccessLogContext() {
        return new HttpAccessLogContext();
    }

    public boolean containsMemoryItem() {
        return this.containsMemoryItem;
    }

    protected Map<String, LogItem<HttpAccessLogContext>> getLogItems(Map<String, String> props) {
        HashMap<String, LogItem<HttpAccessLogContext>> logItems = new HashMap<String, LogItem<HttpAccessLogContext>>();
        logItems.put("$requestId$", new RequestIdItem());
        logItems.put("$userId$", new UserIdItem());
        logItems.put("$url$", new UrlItem());
        logItems.put("$query$", new QueryStringItem());
        logItems.put("$port$", new PortItem());
        logItems.put("$method$", new MethodItem());
        char maskingChar = this.getMaskingChar(props);
        Pattern[] maskingPatterns = this.getMaskingPatterns(props);
        logItems.put("$parameters$", (LogItem<HttpAccessLogContext>)new ParametersItem(maskingChar, maskingPatterns, this.getSeparator(props, PROPS_PARAMETERS_SEPARATOR, DEFAULT_PARAMETERS_SEPARATOR)));
        logItems.put("$sessionScope$", (LogItem<HttpAccessLogContext>)new SessionScopeItem(maskingChar, maskingPatterns, this.getSeparator(props, PROPS_SESSION_SCOPE_SEPARATOR, DEFAULT_SESSION_SCOPE_SEPARATOR)));
        logItems.put("$dispatchingClass$", new DispatchingClassItem());
        logItems.put("$sessionId$", new SessionIdItem());
        logItems.put("$statusCode$", new StatusCodeItem());
        logItems.put("$responseStatusCode$", new ResponseStatusCodeItem());
        logItems.put("$contentPath$", new ContentPathItem());
        logItems.put("$clientIpAddress$", new ClientIpAddressItem());
        logItems.put("$clientHost$", new ClientHostItem());
        logItems.put("$clientUserAgent$", new ClientUserAgentItem());
        DateFormat dateFormat = this.getDateFormat(props);
        logItems.put("$startTime$", (LogItem<HttpAccessLogContext>)new StartTimeItem(dateFormat));
        logItems.put("$endTime$", (LogItem<HttpAccessLogContext>)new EndTimeItem(dateFormat));
        logItems.put("$executionTime$", new ExecutionTimeItem());
        logItems.put("$maxMemory$", new MaxMemoryItem());
        logItems.put("$freeMemory$", new FreeMemoryItem());
        return logItems;
    }

    protected DateFormat getDateFormat(Map<String, String> props) {
        String datePattern = props.get(PROPS_DATE_PATTERN);
        return datePattern != null ? new SimpleDateFormat(datePattern) : DEFAULT_DATE_FORMAT;
    }

    protected String getProp(Map<String, String> props, String propName, String defaultValue) {
        String value = props.get(propName);
        return value != null ? value : defaultValue;
    }

    protected String getSeparator(Map<String, String> props, String propName, String defaultValue) {
        String parametersSeparator = this.getProp(props, propName, defaultValue);
        return parametersSeparator.replace("\\n", Logger.LS).replace("\\t", "\t");
    }

    protected char getMaskingChar(Map<String, String> props) {
        String maskingChar = this.getProp(props, PROPS_MASKING_CHAR, DEFAULT_MASKING_CHAR);
        if (maskingChar.toCharArray().length != 1) {
            throw new IllegalArgumentException(String.format("maskingChar was not char type. maskingChar = [%s]", maskingChar));
        }
        return maskingChar.charAt(0);
    }

    protected Pattern[] getMaskingPatterns(Map<String, String> props) {
        String patterns = props.get(PROPS_MASKING_PATTERNS);
        if (patterns == null) {
            return DEFAULT_MASKING_PATTERNS;
        }
        String[] splitPatterns = MULTIVALUE_SEPARATOR_PATTERN.split(patterns);
        ArrayList<Pattern> maskingPatterns = new ArrayList<Pattern>();
        for (String regex : splitPatterns) {
            if (StringUtil.isNullOrEmpty((String)(regex = regex.trim()))) continue;
            maskingPatterns.add(Pattern.compile(regex, 2));
        }
        return maskingPatterns.toArray(new Pattern[maskingPatterns.size()]);
    }

    public String formatBegin(HttpAccessLogContext context) {
        return LogUtil.formatMessage(this.beginLogItems, (Object)context);
    }

    public String formatParameters(HttpAccessLogContext context) {
        return LogUtil.formatMessage(this.parametersLogItems, (Object)context);
    }

    public String formatDispatchingClass(HttpAccessLogContext context) {
        return LogUtil.formatMessage(this.dispatchingClassLogItems, (Object)context);
    }

    public String formatEnd(HttpAccessLogContext context) {
        return LogUtil.formatMessage(this.endLogItems, (Object)context);
    }

    public boolean isBeginOutputEnabled() {
        return this.beginOutputEnabled;
    }

    public boolean isParametersOutputEnabled() {
        return this.parametersOutputEnabled;
    }

    public boolean isDispatchingClassOutputEnabled() {
        return this.dispatchingClassOutputEnabled;
    }

    public boolean isEndOutputEnabled() {
        return this.endOutputEnabled;
    }

    public static class ClientUserAgentItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            String info = context.getServletRequest().getHeader("User-Agent");
            return info == null ? "" : info;
        }
    }

    public static class FreeMemoryItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return String.valueOf(context.getFreeMemory());
        }
    }

    public static class MaxMemoryItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return String.valueOf(context.getMaxMemory());
        }
    }

    public static class ExecutionTimeItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return String.valueOf(context.getExecutionTime());
        }
    }

    public static class EndTimeItem
    extends DateItemSupport<HttpAccessLogContext> {
        public EndTimeItem(DateFormat dateFormat) {
            super(dateFormat);
        }

        protected Date getDate(HttpAccessLogContext context) {
            return new Date(context.getEndTime());
        }
    }

    public static class StartTimeItem
    extends DateItemSupport<HttpAccessLogContext> {
        public StartTimeItem(DateFormat dateFormat) {
            super(dateFormat);
        }

        protected Date getDate(HttpAccessLogContext context) {
            return new Date(context.getStartTime());
        }
    }

    public static class ClientHostItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getClientHost();
        }
    }

    public static class ClientIpAddressItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getClientIpAddress();
        }
    }

    public static class ContentPathItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getContentPath();
        }
    }

    public static class ResponseStatusCodeItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            int statusCode = HttpResponseUtil.chooseResponseStatusCode(context.response, context.context);
            return statusCode != -1 ? String.valueOf(statusCode) : "";
        }
    }

    public static class StatusCodeItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            int statusCode = context.getStatusCode();
            return statusCode != -1 ? String.valueOf(statusCode) : "";
        }
    }

    public static class SessionIdItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getSessionId();
        }
    }

    public static class DispatchingClassItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getDispatchingClass();
        }
    }

    public static class SessionScopeItem
    extends MaskingMapItemSupport<HttpAccessLogContext> {
        public SessionScopeItem(char maskingChar, Pattern[] maskingPatterns, String varSeparator) {
            super(maskingChar, maskingPatterns, varSeparator);
        }

        protected Map<String, ?> getMap(HttpAccessLogContext context) {
            return context.getSessionScopeMap();
        }
    }

    public static class ParametersItem
    extends MaskingMapItemSupport<HttpAccessLogContext> {
        public ParametersItem(char maskingChar, Pattern[] maskingPatterns, String paramSeparator) {
            super(maskingChar, maskingPatterns, paramSeparator);
        }

        protected Map<String, ?> getMap(HttpAccessLogContext context) {
            return context.getParameters();
        }
    }

    public static class MethodItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getMethod();
        }
    }

    public static class PortItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return String.valueOf(context.getPort());
        }
    }

    public static class QueryStringItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getQueryString();
        }
    }

    public static class UrlItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return context.getUrl();
        }
    }

    public static class UserIdItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return ThreadContext.getUserId();
        }
    }

    public static class RequestIdItem
    implements LogItem<HttpAccessLogContext> {
        public String get(HttpAccessLogContext context) {
            return ThreadContext.getRequestId();
        }
    }

    public static class HttpAccessLogContext {
        private ServletExecutionContext context;
        private String dispatchingClass;
        private HttpRequest request;
        private HttpResponse response;
        private long startTime;
        private long endTime;
        private long maxMemory;
        private long freeMemory;
        private static final Map<String, Object> EMPTY_MAP = Collections.EMPTY_MAP;

        public void setContext(ServletExecutionContext context) {
            this.context = context;
        }

        public HttpServletRequest getServletRequest() throws ClassCastException {
            return this.context.getServletRequest();
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public String getSessionId() {
            HttpSession session = this.getServletRequest().getSession(false);
            return session == null ? "" : session.getId();
        }

        public String getUrl() {
            return this.getServletRequest().getRequestURL().toString();
        }

        public String getQueryString() {
            String queryString = this.getServletRequest().getQueryString();
            return queryString == null ? "" : "?" + queryString;
        }

        public int getPort() {
            return this.getServletRequest().getServerPort();
        }

        public String getMethod() {
            return this.request.getMethod();
        }

        public Map<String, String[]> getParameters() {
            return this.request.getParamMap();
        }

        public Map<String, Object> getSessionScopeMap() {
            return this.context.hasSession() ? this.context.getSessionScopeMap() : EMPTY_MAP;
        }

        public String getDispatchingClass() {
            return this.dispatchingClass;
        }

        public void setDispatchingClass(String dispatchingClass) {
            this.dispatchingClass = dispatchingClass;
        }

        public String getClientIpAddress() {
            return this.getServletRequest().getRemoteAddr();
        }

        public String getClientHost() {
            return this.getServletRequest().getRemoteHost();
        }

        public int getStatusCode() {
            if (this.response == null) {
                return -1;
            }
            return this.response.getStatusCode();
        }

        public String getContentPath() {
            if (this.response == null) {
                return "";
            }
            ResourceLocator locator = this.response.getContentPath();
            return locator != null ? locator.toString() : "";
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public long getExecutionTime() {
            return this.endTime - this.startTime;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public void setFreeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
        }
    }
}

