/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpCharacterEncodingHandler
implements Handler<Object, Object> {
    private Charset defaultEncoding = Charset.forName("UTF-8");
    private boolean appendResponseCharacterEncoding = false;

    @Published(tag={"architect"})
    public HttpCharacterEncodingHandler() {
    }

    public void setDefaultEncoding(String name) {
        this.setDefaultEncodingCharset(Charset.forName(name));
    }

    public void setDefaultEncodingCharset(Charset encoding) {
        this.defaultEncoding = encoding;
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setAppendResponseCharacterEncoding(boolean appendResponseCharacterEncoding) {
        this.appendResponseCharacterEncoding = appendResponseCharacterEncoding;
    }

    public Object handle(Object data, ExecutionContext context) {
        ServletExecutionContext servletExecutionContext = (ServletExecutionContext)context;
        NablarchHttpServletRequestWrapper req = servletExecutionContext.getServletRequest();
        HttpServletResponse res = servletExecutionContext.getServletResponse();
        try {
            req.setCharacterEncoding(this.resolveRequestEncoding((HttpServletRequest)req).name());
            if (this.appendResponseCharacterEncoding) {
                res.setCharacterEncoding(this.resolveResponseEncoding((HttpServletRequest)req).name());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding is not supported.", e);
        }
        return context.handleNext(data);
    }

    @Published(tag={"architect"})
    protected Charset resolveRequestEncoding(HttpServletRequest request) {
        return this.defaultEncoding;
    }

    @Published(tag={"architect"})
    protected Charset resolveResponseEncoding(HttpServletRequest request) {
        return this.defaultEncoding;
    }
}

