/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import nablarch.common.web.WebConfig;
import nablarch.common.web.WebConfigFinder;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.message.ApplicationException;
import nablarch.core.util.Builder;
import nablarch.fw.ExecutionContext;
import nablarch.fw.NoMoreHandlerException;
import nablarch.fw.Result;
import nablarch.fw.results.InternalError;
import nablarch.fw.results.ServiceError;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResourceLocator;
import nablarch.fw.web.message.ErrorMessages;

public class HttpErrorHandler
implements HttpRequestHandler {
    private static final Logger LOGGER = LoggerManager.get(HttpErrorHandler.class);
    protected Pattern writeFailureLogPattern = Pattern.compile("5([1-9][0-9]|0[012456789])");
    private static final String DOCROOT = "servlet:///jsp/";
    private final Map<String, ResourceLocator> defaultPages = new HashMap<String, ResourceLocator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
        HttpResponse res = null;
        try {
            res = (HttpResponse)ctx.handleNext((Object)req);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("HTTP Response: ", new Object[]{res, res.getContentPath()});
            }
        }
        catch (NoMoreHandlerException e) {
            LOGGER.logInfo(Builder.concat((Object[])new Object[]{"There were no Handlers in handlerQueue.", " uri = [", req.getRequestUri(), "]"}), new Object[0]);
            res = HttpResponse.Status.NOT_FOUND.handle(req, ctx);
        }
        catch (HttpErrorResponse e) {
            ctx.setException(e.getCause());
            res = e.getResponse();
            if (e.getCause() instanceof ApplicationException) {
                WebConfig webConfig = WebConfigFinder.getWebConfig();
                ctx.setRequestScopedVar(webConfig.getErrorMessageRequestAttributeName(), (Object)new ErrorMessages((ApplicationException)e.getCause()));
            }
        }
        catch (Result.Error e) {
            if (this.writeFailureLogPattern.matcher(String.valueOf(e.getStatusCode())).matches()) {
                if (e instanceof InternalError) {
                    ((ServiceError)e).writeLog(ctx);
                } else {
                    FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
                }
            }
            ctx.setException(e.getCause());
            res = new HttpResponse(e.getStatusCode());
        }
        catch (RuntimeException e) {
            FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
            ctx.setException((Throwable)e);
            res = HttpResponse.Status.INTERNAL_SERVER_ERROR.handle(req, ctx);
        }
        catch (StackOverflowError e) {
            FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
            ctx.setException((Throwable)e);
            res = HttpResponse.Status.INTERNAL_SERVER_ERROR.handle(req, ctx);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Error e) {
            FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
            ctx.setException((Throwable)e);
            res = HttpResponse.Status.INTERNAL_SERVER_ERROR.handle(req, ctx);
        }
        finally {
            WebConfig webConfig = WebConfigFinder.getWebConfig();
            String varName = webConfig.getErrorMessageRequestAttributeName();
            if (ctx.getRequestScopedVar(varName) == null) {
                ctx.setRequestScopedVar(varName, (Object)ErrorMessages.empty());
            }
        }
        if (res.isBodyEmpty()) {
            res.setContentPath(this.getDefaultPageFor(res.getStatusCode()));
        }
        return res;
    }

    public HttpErrorHandler setDefaultPage(String statusCode, String contentPath) {
        if (!statusCode.matches("[0-9.]{3}")) {
            throw new RuntimeException("invalid status code format.: " + contentPath);
        }
        this.defaultPages.put(statusCode, ResourceLocator.valueOf(contentPath));
        return this;
    }

    public HttpErrorHandler setDefaultPages(Map<String, String> defaultPages) {
        this.defaultPages.clear();
        if (defaultPages != null) {
            for (Map.Entry<String, String> defaultPage : defaultPages.entrySet()) {
                this.setDefaultPage(defaultPage.getKey(), defaultPage.getValue());
            }
        }
        return this;
    }

    public ResourceLocator getDefaultPageFor(int statusCode) {
        String statusCodeStr = Integer.valueOf(statusCode).toString();
        int hiScore = 0;
        ResourceLocator result = null;
        if (this.defaultPages != null) {
            for (Map.Entry<String, ResourceLocator> entry : this.defaultPages.entrySet()) {
                if (entry.getKey().indexOf(46) == -1) {
                    if (!statusCodeStr.equals(entry.getKey())) continue;
                    return entry.getValue();
                }
                int score = this.matchingScore(statusCodeStr, entry.getKey());
                if (hiScore >= score) continue;
                result = entry.getValue();
                hiScore = score;
            }
        }
        return result;
    }

    private int matchingScore(String aStr, String bStr) {
        int score = 0;
        for (int i = 0; i < aStr.length() && i < bStr.length(); ++i) {
            if (aStr.charAt(i) != bStr.charAt(i)) continue;
            ++score;
        }
        return score;
    }

    public void setWriteFailureLogPattern(String writeFailureLogPattern) {
        this.writeFailureLogPattern = Pattern.compile(writeFailureLogPattern);
    }
}

