/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import nablarch.core.util.Builder;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.handler.RewriteRule;
import nablarch.fw.web.HttpRequest;

@Published(tag={"architect"})
public class HttpRequestRewriteRule
extends RewriteRule<HttpRequest, HttpRequestRewriteRule> {
    public String getPathToRewrite(HttpRequest request) {
        return request.getRequestPath();
    }

    public void applyRewrittenPath(String rewrittenPath, HttpRequest request) {
        if (!rewrittenPath.startsWith("servlet://") && !rewrittenPath.startsWith("redirect://")) {
            request.setRequestPath(rewrittenPath);
        }
    }

    protected Object getParam(String type, String name, HttpRequest request, ExecutionContext context) {
        return "header".equals(type) ? request.getHeader(name) : ("param".equals(type) ? request.getParam(name) : ("".equals(type) ? this.getProperty(name, request) : super.getParam(type, name, (Object)request, context)));
    }

    private String getProperty(String name, HttpRequest request) {
        return "paramNames".equals(name) ? Builder.join((Object[])request.getParamMap().keySet().toArray(), (String)",") : ("httpVersion".equals(name) ? request.getHttpVersion() : ("httpMethod".equals(name) ? request.getMethod() : null));
    }

    protected void exportParam(String scope, String name, String value, HttpRequest req, ExecutionContext context) {
        if ("param".equals(scope)) {
            req.getParamMap().put(name, new String[]{value});
        } else {
            super.exportParam(scope, name, value, (Object)req, context);
        }
    }
}

