/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.ArrayList;
import java.util.List;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.ContentPathRewriteRule;
import nablarch.fw.web.handler.HttpRequestRewriteRule;

public class HttpRewriteHandler
implements Handler<HttpRequest, HttpResponse> {
    private final List<HttpRequestRewriteRule> requestPathRewriteRules = new ArrayList<HttpRequestRewriteRule>();
    private final List<ContentPathRewriteRule> contentPathRewriteRules = new ArrayList<ContentPathRewriteRule>();

    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        String path = this.rewriteRequestPath(request, context);
        if (path.startsWith("servlet://") || path.startsWith("redirect://")) {
            return new HttpResponse(path);
        }
        HttpResponse response = (HttpResponse)context.handleNext((Object)request);
        if (response.getContentPath() != null) {
            this.rewriteContentPath(response, context);
        }
        return response;
    }

    private String rewriteRequestPath(HttpRequest request, ExecutionContext context) {
        for (HttpRequestRewriteRule rule : this.requestPathRewriteRules) {
            String rewrittenPath = rule.rewrite(request, context);
            if (rewrittenPath == null) continue;
            return rewrittenPath;
        }
        return request.getRequestPath();
    }

    private String rewriteContentPath(HttpResponse response, ExecutionContext context) {
        for (ContentPathRewriteRule rule : this.contentPathRewriteRules) {
            String path = rule.rewrite(response, context);
            if (path == null) continue;
            return path;
        }
        return response.getContentPath().toString();
    }

    public HttpRewriteHandler setRequestPathRewriteRules(List<HttpRequestRewriteRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("the argument [rules] must not be null.");
        }
        this.requestPathRewriteRules.clear();
        this.requestPathRewriteRules.addAll(rules);
        return this;
    }

    public HttpRewriteHandler addRequestPathRewriteRule(HttpRequestRewriteRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("the argument [rule] must not be null.");
        }
        this.requestPathRewriteRules.add(rule);
        return this;
    }

    public HttpRewriteHandler setContentPathRewriteRules(List<ContentPathRewriteRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("the argument [rules] must not be null.");
        }
        this.contentPathRewriteRules.clear();
        this.contentPathRewriteRules.addAll(rules);
        return this;
    }

    public HttpRewriteHandler addContentPathRewriteRule(ContentPathRewriteRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("the argument [rule] must not be null.");
        }
        this.contentPathRewriteRules.add(rule);
        return this;
    }
}

