/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.handler.normalizer.Normalizer;
import nablarch.fw.web.handler.normalizer.TrimNormalizer;

public class NormalizationHandler
implements Handler<HttpRequest, Object> {
    private List<Normalizer> normalizers = null;

    public NormalizationHandler() {
        this.setNormalizers(Collections.singletonList(new TrimNormalizer()));
    }

    public Object handle(HttpRequest request, ExecutionContext context) {
        Map<String, String[]> parameters = request.getParamMap();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            for (Normalizer normalizer : this.normalizers) {
                if (!normalizer.canNormalize(key)) continue;
                value = normalizer.normalize(value);
            }
            parameters.put(key, value);
        }
        return context.handleNext((Object)request);
    }

    public void setNormalizers(List<Normalizer> normalizers) {
        this.normalizers = Collections.unmodifiableList(normalizers);
    }
}

