/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler.csrf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.handler.csrf.VerificationTargetMatcher;

public class HttpMethodVerificationTargetMatcher
implements VerificationTargetMatcher {
    private static final Set<String> DEFAULT_ALLOWED_METHODS;
    private Set<String> allowedMethods = DEFAULT_ALLOWED_METHODS;

    @Override
    public boolean match(HttpRequest request) {
        return !this.allowedMethods.contains(request.getMethod());
    }

    public void setAllowedMethods(Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    static {
        HashSet<String> allowedMethods = new HashSet<String>();
        allowedMethods.add("GET");
        allowedMethods.add("HEAD");
        allowedMethods.add("TRACE");
        allowedMethods.add("OPTIONS");
        DEFAULT_ALLOWED_METHODS = Collections.unmodifiableSet(allowedMethods);
    }
}

