/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler.health;

import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import nablarch.core.db.dialect.Dialect;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.handler.health.HealthChecker;

public class DbHealthChecker
extends HealthChecker {
    private DataSource dataSource;
    private Dialect dialect;

    public DbHealthChecker() {
        this.setName("DB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryOut(HttpRequest request, ExecutionContext context) throws Exception {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(this.dialect.getPingSql());
            statement.execute();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }
}

