/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler.health;

import java.util.List;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.health.HealthCheckResult;

@Published(tag={"architect"})
public class HealthCheckResponseBuilder {
    private int healthyStatusCode = HttpResponse.Status.OK.getStatusCode();
    private String healthyStatus = "UP";
    private int unhealthyStatusCode = HttpResponse.Status.SERVICE_UNAVAILABLE.getStatusCode();
    private String unhealthyStatus = "DOWN";
    private boolean writeBody = true;

    public HttpResponse build(HttpRequest request, ExecutionContext context, HealthCheckResult result) {
        HttpResponse response = new HttpResponse();
        response.setStatusCode(result.isHealthy() ? this.healthyStatusCode : this.unhealthyStatusCode);
        if (this.writeBody) {
            response.setContentType(this.getContentType());
            response.write(this.buildResponseBody(request, context, result));
        }
        return response;
    }

    protected String getContentType() {
        return "application/json";
    }

    protected String buildResponseBody(HttpRequest request, ExecutionContext context, HealthCheckResult result) {
        if (result.getTargets().isEmpty()) {
            return String.format("{\"status\":\"%s\"}", this.getStatus(result.isHealthy()));
        }
        return String.format("{\"status\":\"%s\",\"targets\":[%s]}", this.getStatus(result.isHealthy()), this.targets(result.getTargets()));
    }

    private String targets(List<HealthCheckResult.Target> targets) {
        StringBuilder sb = new StringBuilder();
        for (HealthCheckResult.Target target : targets) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(String.format("{\"name\":\"%s\",\"status\":\"%s\"}", target.getName(), this.getStatus(target.isHealthy())));
        }
        return sb.toString();
    }

    protected String getStatus(boolean isHealthy) {
        return isHealthy ? this.healthyStatus : this.unhealthyStatus;
    }

    public void setHealthyStatusCode(int healthyStatusCode) {
        this.healthyStatusCode = healthyStatusCode;
    }

    public void setHealthyStatus(String healthyStatus) {
        this.healthyStatus = healthyStatus;
    }

    public void setUnhealthyStatusCode(int unhealthyStatusCode) {
        this.unhealthyStatusCode = unhealthyStatusCode;
    }

    public void setUnhealthyStatus(String unhealthyStatus) {
        this.unhealthyStatus = unhealthyStatus;
    }

    public void setWriteBody(boolean writeBody) {
        this.writeBody = writeBody;
    }
}

