/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler.secure;

import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.secure.SecureResponseHeader;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class FrameOptionsHeader
implements SecureResponseHeader {
    private OPTIONS option = OPTIONS.SAMEORIGIN;

    public void setOption(String xFrameOptions) {
        try {
            this.option = OPTIONS.valueOf(xFrameOptions);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("invalid X-Frame-Options. value = [%s]", xFrameOptions), e);
        }
    }

    @Override
    public boolean isOutput(HttpResponse response, ServletExecutionContext context) {
        return this.option == OPTIONS.SAMEORIGIN || this.option == OPTIONS.DENY;
    }

    @Override
    public String getName() {
        return "X-Frame-Options";
    }

    @Override
    public String getValue() {
        return this.option.toString();
    }

    private static enum OPTIONS {
        DENY,
        SAMEORIGIN,
        NONE;

    }
}

