/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler.secure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.secure.SecureResponseHeader;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class ReferrerPolicyHeader
implements SecureResponseHeader {
    private static final Set<String> VALUES = new HashSet<String>(Arrays.asList("no-referrer", "no-referrer-when-downgrade", "origin", "origin-when-cross-origin", "same-origin", "strict-origin", "strict-origin-when-cross-origin", "unsafe-url"));
    private String value = "strict-origin-when-cross-origin";

    public void setValue(String value) {
        if (!VALUES.contains(value)) {
            throw new IllegalArgumentException(String.format("The value specified in the Referrer-Policy header is invalid. value = [%s]", value));
        }
        this.value = value;
    }

    @Override
    public String getName() {
        return "Referrer-Policy";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isOutput(HttpResponse response, ServletExecutionContext context) {
        return true;
    }
}

