/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.interceptor;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Interceptor;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;

@Documented
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Interceptor(value=Impl.class)
@Published
public @interface OnError {
    public Class<? extends RuntimeException> type();

    public String path();

    public int statusCode() default 400;

    public static class Impl
    extends Interceptor.Impl<HttpRequest, HttpResponse, OnError> {
        public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
            OnError onError = (OnError)this.getInterceptor();
            Class<? extends RuntimeException> errorType = onError.type();
            try {
                return (HttpResponse)this.getOriginalHandler().handle((Object)req, ctx);
            }
            catch (RuntimeException e) {
                if (errorType.isAssignableFrom(e.getClass())) {
                    throw new HttpErrorResponse(onError.statusCode(), onError.path(), e);
                }
                throw e;
            }
        }
    }
}

