/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.core.message.ApplicationException;
import nablarch.core.message.Message;
import nablarch.core.validation.ValidationResultMessage;

public class ErrorMessages {
    private static final ErrorMessages EMPTY_INSTANCE = new ErrorMessages();
    private final List<String> allMessages = new ArrayList<String>();
    private final List<String> globalMessages = new ArrayList<String>();
    private final PropertyMessages propertyMessages = new PropertyMessages();

    public ErrorMessages(ApplicationException applicationException) {
        for (Message message : applicationException.getMessages()) {
            String messageText = message.formatMessage();
            this.allMessages.add(messageText);
            if (message instanceof ValidationResultMessage) {
                this.propertyMessages.addMessage(((ValidationResultMessage)message).getPropertyName(), messageText);
                continue;
            }
            this.globalMessages.add(messageText);
        }
    }

    private ErrorMessages() {
    }

    public static ErrorMessages empty() {
        return EMPTY_INSTANCE;
    }

    public String getMessage(String propertyName) {
        this.verifyPropertyName(propertyName);
        return this.propertyMessages.getMessage(propertyName);
    }

    public boolean hasError(String propertyName) {
        this.verifyPropertyName(propertyName);
        return this.propertyMessages.contains(propertyName);
    }

    private void verifyPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null.");
        }
    }

    public List<String> getPropertyMessages() {
        return Collections.unmodifiableList(this.propertyMessages.messages);
    }

    public List<String> getGlobalMessages() {
        return Collections.unmodifiableList(this.globalMessages);
    }

    public List<String> getAllMessages() {
        return Collections.unmodifiableList(this.allMessages);
    }

    private static class PropertyMessages {
        private final List<String> messages = new ArrayList<String>();
        private final Map<String, Integer> messageIndex = new HashMap<String, Integer>();

        private PropertyMessages() {
        }

        private void addMessage(String propertyName, String messageText) {
            this.messages.add(messageText);
            this.messageIndex.put(propertyName, this.messages.size() - 1);
        }

        private String getMessage(String propertyName) {
            Integer index = this.messageIndex.get(propertyName);
            return index != null ? this.messages.get(index) : null;
        }

        private boolean contains(String propertyName) {
            return this.messageIndex.containsKey(propertyName);
        }
    }
}

