/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import nablarch.fw.results.InternalError;
import nablarch.fw.web.HttpCookie;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;

public class HttpRequestWrapper
extends HttpRequest {
    private final NablarchHttpServletRequestWrapper servletRequest;
    private final HttpCookie httpCookie;

    public HttpRequestWrapper(NablarchHttpServletRequestWrapper req) {
        this.servletRequest = req;
        String contextPath = req.getContextPath();
        String requestUri = req.getRequestURI().replaceFirst(Pattern.quote(contextPath), "");
        this.setRequestUri(requestUri);
        this.httpCookie = new HttpCookie();
        Cookie[] cookies = this.servletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.httpCookie.put(cookie.getName(), cookie.getValue());
            }
        }
    }

    @Override
    public String getMethod() {
        return this.servletRequest.getMethod().trim();
    }

    @Override
    public String getHttpVersion() {
        return this.servletRequest.getProtocol().trim();
    }

    @Override
    public Map<String, String[]> getParamMap() {
        return this.servletRequest.getParameterMap();
    }

    @Override
    public String[] getParam(String name) {
        return this.servletRequest.getParameterMap().get(name);
    }

    @Override
    public HttpRequest setParam(String name, String ... params) {
        this.servletRequest.getParameterMap().put(name, params);
        return this;
    }

    @Override
    public HttpRequest setParamMap(Map<String, String[]> params) {
        this.servletRequest.setParamMap(params);
        return this;
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.servletRequest.getHeaderMap();
    }

    @Override
    public String getHeader(String headerName) {
        return this.servletRequest.getHeader(headerName);
    }

    @Override
    public HttpCookie getCookie() {
        return this.httpCookie;
    }

    public ServletInputStream getInputStream() {
        try {
            return this.servletRequest.getInputStream();
        }
        catch (IOException e) {
            throw new InternalError((Throwable)e);
        }
    }

    public String getContentType() {
        String type1 = this.servletRequest.getHeader("Content-Type");
        String type2 = this.servletRequest.getContentType();
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return type1.length() <= type2.length() ? type2 : type1;
    }

    public int getContentLength() {
        return this.servletRequest.getContentLength();
    }

    public String getCharacterEncoding() {
        return this.servletRequest.getCharacterEncoding();
    }
}

