/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.servlet;

import javax.servlet.http.HttpServletRequest;

public final class UriUtil {
    private UriUtil() {
    }

    public static String convertToPathFromContextRoot(String path, HttpServletRequest request) {
        int lastSlashIndex;
        int contextPathLength;
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith("http:") || path.startsWith("https:")) {
            int fromIndex = path.startsWith("http:") ? "http://".length() : "https://".length();
            if ((fromIndex = (path = path.substring(fromIndex)).indexOf("/")) < 0) {
                return "/";
            }
            path = path.substring(fromIndex);
            String contextPath = request.getContextPath();
            if (contextPath.length() != 1 && path.startsWith(contextPath)) {
                path = path.substring(contextPath.length());
            }
            return path.length() == 0 ? "/" : path;
        }
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        if ((contextPathLength = request.getContextPath().length()) > 1) {
            uri = uri.substring(contextPathLength);
        }
        if ((lastSlashIndex = uri.lastIndexOf("/")) != -1) {
            uri = uri.substring(0, lastSlashIndex);
        }
        return uri + "/" + path;
    }
}

