/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload;

import java.util.List;
import java.util.Map;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.Builder;
import nablarch.fw.ExecutionContext;
import nablarch.fw.results.BadRequest;
import nablarch.fw.results.RequestEntityTooLarge;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.HttpRequestWrapper;
import nablarch.fw.web.upload.MultipartContext;
import nablarch.fw.web.upload.MultipartParser;
import nablarch.fw.web.upload.PartInfo;
import nablarch.fw.web.upload.PartInfoHolder;
import nablarch.fw.web.upload.UploadSettings;

public class MultipartHandler
implements HttpRequestHandler {
    private UploadSettings settings = new UploadSettings();
    private static final String COMPLETED_FLG_KEY = "nablarch_multipart_completed_flg";
    private static final Logger LOGGER = LoggerManager.get(MultipartHandler.class);

    public void setUploadSettings(UploadSettings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        PartInfoHolder parts;
        HttpRequestWrapper wrapper = this.cast(request);
        if (!MultipartParser.isMultipart(wrapper.getContentType()) || this.isParseCompleted(context)) {
            return (HttpResponse)context.handleNext((Object)request);
        }
        MultipartParser parser = this.createParser(wrapper, this.settings);
        try {
            parts = parser.parse();
        }
        catch (BadRequest e) {
            context.setException((Throwable)e);
            return new HttpResponse(e.getStatusCode());
        }
        catch (RequestEntityTooLarge e) {
            context.setException((Throwable)e);
            return new HttpResponse(e.getStatusCode());
        }
        context.setRequestScopedVar(COMPLETED_FLG_KEY, (Object)Boolean.TRUE);
        request.setMultipart((Map<String, List<PartInfo>>)((Object)parts));
        parts.logAllPart();
        try {
            HttpResponse httpResponse = (HttpResponse)context.handleNext((Object)request);
            return httpResponse;
        }
        finally {
            this.cleanup(parts);
        }
    }

    MultipartParser createParser(HttpRequestWrapper wrapper, UploadSettings settings) {
        return new MultipartParser(wrapper.getInputStream(), wrapper.getParamMap(), settings, new MultipartContext(wrapper));
    }

    private HttpRequestWrapper cast(HttpRequest request) throws UnsupportedOperationException {
        try {
            return (HttpRequestWrapper)request;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException(Builder.concat((Object[])new Object[]{"MultipartHandler expects ", HttpRequestWrapper.class.getName(), " as HttpRequest. but was ", request.getClass().getName(), "."}), e);
        }
    }

    private boolean isParseCompleted(ExecutionContext context) {
        Boolean competedFlg = (Boolean)context.getRequestScopedVar(COMPLETED_FLG_KEY);
        return competedFlg != null && competedFlg != false;
    }

    private void cleanup(PartInfoHolder parts) {
        if (this.settings.isAutoCleaning()) {
            try {
                parts.cleanup();
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to delete temp file.", t, new Object[0]);
            }
        }
    }
}

