/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FileUtil;
import nablarch.core.util.StringUtil;
import nablarch.fw.results.BadRequest;
import nablarch.fw.results.InternalError;
import nablarch.fw.results.RequestEntityTooLarge;
import nablarch.fw.web.upload.MultipartContext;
import nablarch.fw.web.upload.MultipartInputStream;
import nablarch.fw.web.upload.PartInfo;
import nablarch.fw.web.upload.PartInfoHolder;
import nablarch.fw.web.upload.UploadSettings;

class MultipartParser {
    private final MultipartContext ctx;
    private final MultipartInputStream in;
    private final Map<String, String[]> paramMap;
    private final File saveDir;
    private static final Logger LOGGER = LoggerManager.get(MultipartParser.class);

    MultipartParser(ServletInputStream in, Map<String, String[]> paramMap, UploadSettings settings, MultipartContext ctx) {
        this.in = new MultipartInputStream(in, ctx, settings.getContentLengthLimit());
        this.ctx = ctx;
        this.paramMap = paramMap;
        this.saveDir = settings.getSaveDir();
    }

    static boolean isMultipart(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("multipart/form-data");
    }

    PartInfoHolder parse() {
        if (this.ctx.getContentLength() == 0) {
            return PartInfoHolder.getEmptyInstance();
        }
        PartInfoHolder parts = new PartInfoHolder();
        try {
            this.parse(parts);
        }
        catch (BadRequest e) {
            try {
                parts.cleanup();
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to delete temp file.", t, new Object[0]);
            }
            throw e;
        }
        catch (RequestEntityTooLarge e) {
            try {
                parts.cleanup();
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to delete temp file.", t, new Object[0]);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                this.in.consume();
                parts.cleanup();
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to delete temp file.", t, new Object[0]);
            }
            throw new InternalError((Throwable)e);
        }
        return parts;
    }

    void parse(PartInfoHolder parts) throws IOException {
        String boundary = MultipartParser.extractBoundary(this.ctx.getContentType());
        this.in.skipTillBoundary(boundary);
        this.readPart(parts);
    }

    static String extractBoundary(String contentType) throws BadRequest {
        int index = contentType.lastIndexOf("boundary=");
        if (index == -1) {
            throw new BadRequest("can't find boundary in multipart.");
        }
        String boundary = contentType.substring(index + 9);
        if (boundary.startsWith("\"")) {
            boundary = boundary.replace('\"', ' ').trim();
        }
        if (boundary.contains(";")) {
            int pos = boundary.indexOf(59);
            boundary = boundary.substring(0, pos);
        }
        return "--" + boundary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPart(PartInfoHolder result) throws IOException {
        String line = this.in.readLine();
        while (!StringUtil.isNullOrEmpty((String)line)) {
            String value;
            this.in.reset();
            List<String> headers = this.getHeaderLinesInPart(line);
            PartInfo part = PartInfo.newInstance(headers);
            String name = part.getName();
            if (part.isFile()) {
                try {
                    this.write(part);
                }
                finally {
                    result.addPart(part);
                }
                value = part.getFileName();
            } else {
                value = this.in.readParam();
            }
            this.addParam(name, value);
            line = this.in.readLine();
        }
    }

    private List<String> getHeaderLinesInPart(String line) throws IOException {
        ArrayList<String> headers = new ArrayList<String>();
        while (line != null && line.length() > 0) {
            String nextLine = null;
            StringBuilder sb = new StringBuilder(line);
            boolean continuous = true;
            do {
                if ((nextLine = this.in.readLine()) != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    sb.append(nextLine);
                    continue;
                }
                continuous = false;
            } while (continuous);
            headers.add(sb.toString());
            line = nextLine;
        }
        return headers;
    }

    private void addParam(String name, String ... values) {
        String[] newValue = values;
        if (this.paramMap.containsKey(name)) {
            String[] orig = this.paramMap.get(name);
            newValue = StringUtil.merge((String[][])new String[][]{orig, newValue});
        }
        this.paramMap.put(name, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(PartInfo part) throws IOException {
        OutputStream out = null;
        try {
            out = part.getOutputStream(this.saveDir);
            int sum = 0;
            int read = 0;
            byte[] buf8k = new byte[8192];
            while ((read = this.in.read(buf8k)) != -1) {
                sum += read;
                out.write(buf8k, 0, read);
            }
            part.setSize(sum);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{out});
    }
}

