/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.Builder;
import nablarch.core.util.FileUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.results.BadRequest;
import nablarch.fw.results.InternalError;

public final class PartInfo {
    private static final Logger LOGGER = LoggerManager.get(PartInfo.class);
    private static final int NOT_FOUND = -1;
    private String name;
    private String fileName;
    private String contentType = "application/octet-stream";
    private File savedFile;
    private int size = 0;
    private Status status = Status.NOT_YET_SAVED;
    private static final char[] HEX_REPS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Random RANDOM_GEN = new Random();
    private static final String DEFAULT_FILE_SUFFIX = ".dat";
    private static AtomicInteger seq = new AtomicInteger(0);

    private PartInfo() {
    }

    static PartInfo newInstance(List<String> headers) {
        PartInfo info = new PartInfo();
        for (String header : headers) {
            String lower = header.toLowerCase();
            if (lower.startsWith("content-disposition:")) {
                info.parseContentDisposition(header, lower);
                continue;
            }
            if (!lower.startsWith("content-type:")) continue;
            info.setContentType(header);
        }
        return info;
    }

    @Published(tag={"architect"})
    public static PartInfo newInstance(String name) {
        PartInfo info = new PartInfo();
        info.name = name;
        return info;
    }

    @Published
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.savedFile);
        }
        catch (FileNotFoundException e) {
            throw new InternalError("opening upload file failed. [" + this.toString() + "]", (Throwable)e);
        }
    }

    private void parseContentDisposition(String orig, String lower) {
        int slash;
        int start = lower.indexOf("content-disposition: ");
        int end = lower.indexOf(";");
        if (end == -1) {
            throw new BadRequest(Builder.concat((Object[])new Object[]{"invalid Content-Disposition. ; not found. ", "[", orig, "]"}));
        }
        String disposition = lower.substring(start + 21, end);
        if (!"form-data".equals(disposition)) {
            throw new BadRequest(Builder.concat((Object[])new Object[]{"invalid Content-Disposition. form-data expected. ", "but was [", disposition, "]."}));
        }
        start = lower.indexOf("name=\"", end);
        end = lower.indexOf("\"", start + 7);
        int startOffset = 6;
        if (start == -1 || end == -1) {
            start = lower.indexOf("name=", end);
            end = lower.indexOf(";", start + 6);
            if (start == -1) {
                throw new BadRequest(Builder.concat((Object[])new Object[]{"invalid content disposition. name not found. ", "[", orig, "]"}));
            }
            if (end == -1) {
                end = orig.length();
            }
            startOffset = 5;
        }
        String name = orig.substring(start + startOffset, end);
        String fileName = null;
        start = lower.indexOf("filename=\"", end + 2);
        end = lower.indexOf("\"", start + 10);
        if (start != -1 && end != -1 && (slash = Math.max((fileName = orig.substring(start + 10, end)).lastIndexOf(47), fileName.lastIndexOf(92))) > -1) {
            fileName = fileName.substring(slash + 1);
        }
        this.name = name;
        this.fileName = fileName;
    }

    private void setContentType(String line) {
        int end = line.indexOf(";");
        if (end == -1) {
            end = line.length();
        }
        this.contentType = line.substring(13, end).trim();
    }

    boolean isFile() {
        return StringUtil.hasValue((String)this.fileName);
    }

    public String getName() {
        return this.name;
    }

    @Published
    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    String generateFileName() {
        long current = System.currentTimeMillis();
        int sequence = PartInfo.generateSequence();
        String ext = this.extractFileSuffix(this.fileName);
        return Builder.concat((Object[])new Object[]{current, sequence, this.getRandomToken(), ext});
    }

    private String getRandomToken() {
        int length = 5;
        byte[] random = new byte[length];
        char[] hex = new char[length * 2];
        RANDOM_GEN.nextBytes(random);
        for (int i = 0; i < length; ++i) {
            byte b = random[i];
            hex[2 * i] = HEX_REPS[(b & 0xFF) >>> 4];
            hex[2 * i + 1] = HEX_REPS[b & 0xF];
        }
        return new String(hex);
    }

    OutputStream getOutputStream(File saveDir) {
        this.savedFile = this.createNewFile(saveDir);
        this.status = Status.SAVED;
        try {
            return new BufferedOutputStream(new FileOutputStream(this.savedFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("unexpected exception occurred. file=[" + this.savedFile + "]", e);
        }
    }

    private File createNewFile(File saveDir) {
        if (this.status != Status.NOT_YET_SAVED) {
            throw new IllegalStateException("already saved. [" + this.savedFile.getAbsolutePath() + "]");
        }
        String newFileName = this.generateFileName();
        return new File(saveDir, newFileName);
    }

    void clean() {
        if (this.status != Status.SAVED) {
            return;
        }
        if (!FileUtil.deleteFile((File)this.savedFile)) {
            LOGGER.logWarn("could not delete a temporary file: " + this.savedFile.getAbsolutePath(), new Object[0]);
        }
    }

    String extractFileSuffix(String fileName) {
        String suffix = FileUtil.extractSuffix((String)fileName);
        return suffix.length() == 0 ? DEFAULT_FILE_SUFFIX : suffix;
    }

    private static synchronized int generateSequence() {
        seq.compareAndSet(Integer.MAX_VALUE, 0);
        return seq.getAndIncrement();
    }

    public String toString() {
        return Builder.concat((Object[])new Object[]{"PartInfo {", "name='", this.name, Character.valueOf('\''), ", fileName='", this.fileName, Character.valueOf('\''), ", contentType='", this.contentType, Character.valueOf('\''), ", size=", this.size, ", savedFile=", this.savedFile, Character.valueOf('}')});
    }

    @Published
    public int size() {
        return this.size;
    }

    @Published(tag={"architect"})
    public void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size must not be negative. [" + size + "]");
        }
        this.size = size;
    }

    @Published(tag={"architect"})
    public void setSavedFile(File file) {
        this.savedFile = file;
        this.fileName = file.getName();
        this.status = Status.SAVED;
    }

    @Published(tag={"architect"})
    public File getSavedFile() {
        return this.savedFile;
    }

    @Published(tag={"architect"})
    public void moveTo(File dir, String name) {
        switch (this.status) {
            case NOT_YET_SAVED: {
                throw new IllegalStateException("upload file not saved yet.");
            }
            case SAVED: {
                File dest = new File(dir, name);
                FileUtil.move((File)this.savedFile, (File)dest);
                this.status = Status.REMOVED;
                return;
            }
            case REMOVED: {
                throw new IllegalStateException("upload already removed.");
            }
        }
        throw new IllegalStateException("unexpected state.");
    }

    private static enum Status {
        NOT_YET_SAVED,
        SAVED,
        REMOVED;

    }
}

