/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.useragent;

import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

public class UserAgent {
    @Published
    public static final String DEFAULT_TYPE_VALUE = "UnknownType";
    @Published
    public static final String DEFAULT_NAME_VALUE = "UnknownName";
    @Published
    public static final String DEFAULT_VERSION_VALUE = "UnknownVersion";
    private final String text;
    private String osType;
    private String osName;
    private String osVersion;
    private String browserType;
    private String browserName;
    private String browserVersion;

    @Published(tag={"architect"})
    public UserAgent(String text) {
        this.text = text;
    }

    @Published(tag={"architect"})
    public UserAgent(UserAgent original) {
        this.text = original.getText();
        this.setBrowserType(original.getBrowserType());
        this.setBrowserName(original.getBrowserName());
        this.setBrowserVersion(original.getBrowserVersion());
        this.setOsType(original.getOsType());
        this.setOsName(original.getOsName());
        this.setOsVersion(original.getOsVersion());
    }

    @Published
    public String getText() {
        return StringUtil.nullToEmpty((String)this.text);
    }

    @Published
    public String getBrowserType() {
        return this.nullToDefault(this.browserType, DEFAULT_TYPE_VALUE);
    }

    @Published(tag={"architect"})
    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    @Published
    public String getBrowserName() {
        return this.nullToDefault(this.browserName, DEFAULT_NAME_VALUE);
    }

    @Published(tag={"architect"})
    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    @Published
    public String getBrowserVersion() {
        return this.nullToDefault(this.browserVersion, DEFAULT_VERSION_VALUE);
    }

    @Published(tag={"architect"})
    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    @Published
    public String getOsType() {
        return this.nullToDefault(this.osType, DEFAULT_TYPE_VALUE);
    }

    @Published(tag={"architect"})
    public void setOsType(String osType) {
        this.osType = osType;
    }

    @Published
    public String getOsName() {
        return this.nullToDefault(this.osName, DEFAULT_NAME_VALUE);
    }

    @Published(tag={"architect"})
    public void setOsName(String osName) {
        this.osName = osName;
    }

    @Published
    public String getOsVersion() {
        return this.nullToDefault(this.osVersion, DEFAULT_VERSION_VALUE);
    }

    @Published(tag={"architect"})
    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    private String nullToDefault(String str, String alternative) {
        return str == null ? alternative : str;
    }
}

