/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util;

import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public final class Base64Util {
    private static final char[] ENCODING;
    private static final byte[] DECODING;

    private Base64Util() {
    }

    public static String encode(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuilder base64 = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            byte b3;
            byte b1 = Base64Util.getByte(b, i++);
            base64.append(ENCODING[b1 >>> 2 & 0x3F]);
            byte b2 = Base64Util.getByte(b, i++);
            base64.append(ENCODING[(b1 & 3) << 4 | b2 >>> 4 & 0xF]);
            if (i == b.length) {
                b3 = Base64Util.getByte(b, i++);
                base64.append(ENCODING[(b2 & 0xF) << 2 | b3 >>> 6 & 3]);
                base64.append('=');
                continue;
            }
            if (i < b.length) {
                b3 = Base64Util.getByte(b, i++);
                base64.append(ENCODING[(b2 & 0xF) << 2 | b3 >>> 6 & 3]);
                base64.append(ENCODING[b3 & 0x3F]);
                continue;
            }
            base64.append("==");
        }
        return base64.toString();
    }

    private static byte getByte(byte[] b, int pos) {
        return pos < b.length ? b[pos] : (byte)0;
    }

    public static byte[] decode(String base64) throws IllegalArgumentException {
        if (base64 == null) {
            return null;
        }
        if (base64.length() == 0) {
            return new byte[0];
        }
        int length = base64.length();
        if (length % 4 != 0) {
            throw new IllegalArgumentException(String.format("length of base64 was invalid. base64 = [%s], length = [%s]", base64, length));
        }
        if (base64.substring(0, length - 2).indexOf("=") != -1 || '=' == base64.charAt(length - 2) && '=' != base64.charAt(length - 1)) {
            throw new IllegalArgumentException(String.format("position of '=' in base64 was invalid. base64 = [%s]", base64));
        }
        if (Base64Util.containsInvalidCharacter(base64)) {
            throw new IllegalArgumentException(String.format("base64 contained invalid character. base64 = [%s]", base64));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < base64.length()) {
            char c1 = base64.charAt(i++);
            char c2 = base64.charAt(i++);
            char c3 = base64.charAt(i++);
            char c4 = base64.charAt(i++);
            byte b1 = DECODING[c1];
            byte b2 = 0;
            b2 = DECODING[c2];
            baos.write((byte)((b1 & 0x3F) << 2 | b2 >>> 4 & 3));
            byte b3 = 0;
            if (c3 == '=') break;
            b3 = DECODING[c3];
            baos.write((byte)((b2 & 0xF) << 4 | b3 >>> 2 & 0xF));
            if (c4 == '=') continue;
            byte b4 = DECODING[c4];
            baos.write((byte)((b3 & 3) << 6 | b4 & 0x3F));
        }
        return baos.toByteArray();
    }

    private static boolean containsInvalidCharacter(String base64) {
        StringTokenizer tokenizer = new StringTokenizer(base64.toLowerCase(), "0123456789abcdefghijklmnopqrstuvwxyz+/=", false);
        return tokenizer.hasMoreTokens();
    }

    static {
        int i;
        ENCODING = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DECODING = new byte[124];
        for (i = 0; i < DECODING.length; ++i) {
            Base64Util.DECODING[i] = 0;
        }
        for (i = 0; i < ENCODING.length; ++i) {
            Base64Util.DECODING[Base64Util.ENCODING[i]] = (byte)i;
        }
    }
}

