/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Result;

public abstract class DispatchHandler<TData, TResult, TSelf extends Handler<TData, TResult>>
implements Handler<TData, TResult> {
    private static final Logger LOGGER = LoggerManager.get(DispatchHandler.class);
    private boolean immediate = true;

    protected abstract Class<?> getHandlerClass(TData var1, ExecutionContext var2) throws ClassNotFoundException;

    public TResult handle(TData req, ExecutionContext ctx) {
        Handler<TData, TResult> handler = null;
        Object delegate = null;
        String fqn = null;
        Class<?> clazz = null;
        try {
            clazz = this.getHandlerClass(req, ctx);
            fqn = clazz.getName();
            delegate = clazz.newInstance();
            handler = this.createHandlerFor(delegate, ctx);
        }
        catch (ClassNotFoundException e) {
            String message = "Couldn't find handler.: " + fqn;
            LOGGER.logInfo(message, (Throwable)e, new Object[0]);
            throw new Result.NotFound(message, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (handler == null) {
            String message = "Couldn't instantiate handler.: " + fqn;
            LOGGER.logInfo(message, new Object[0]);
            throw new Result.NotFound(message);
        }
        if (this.immediate) {
            ctx.addHandler(0, handler);
        } else {
            ctx.addHandler(handler);
        }
        return (TResult)ctx.handleNext(req);
    }

    protected Handler<TData, TResult> createHandlerFor(Object delegate, ExecutionContext ctx) {
        if (delegate instanceof Handler) {
            return (Handler)delegate;
        }
        if (ctx.getMethodBinder() != null) {
            return ctx.getMethodBinder().bind(delegate);
        }
        return null;
    }

    public TSelf setImmediate(boolean immediate) {
        this.immediate = immediate;
        return (TSelf)this;
    }

    protected void writeDispatchingClassLog(TData data, ExecutionContext context, String fqn) {
    }
}

