/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.fw.ExceptionHandler;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.Request;
import nablarch.fw.Result;
import nablarch.fw.results.InternalError;
import nablarch.fw.results.ServiceError;

public class GlobalErrorHandler
implements Handler<Request<?>, Object>,
ExceptionHandler {
    private static final Logger LOGGER = LoggerManager.get(GlobalErrorHandler.class);

    public Object handle(Request<?> req, ExecutionContext context) {
        try {
            return context.handleNext(req);
        }
        catch (Error e) {
            return this.handleError(e, context);
        }
        catch (RuntimeException e) {
            return this.handleRuntimeException(e, context);
        }
    }

    public Result handleError(Error e, ExecutionContext context) throws Error, RuntimeException {
        if (e instanceof ThreadDeath) {
            LOGGER.logInfo("Uncaught error: ", (Throwable)e, new Object[0]);
            throw e;
        }
        if (e instanceof StackOverflowError) {
            FailureLogUtil.logFatal((Throwable)e, (Object)context.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
            return new InternalError(e);
        }
        if (e instanceof OutOfMemoryError) {
            System.err.println("OutOfMemoryError occurred: " + e.getMessage());
            try {
                FailureLogUtil.logFatal((Throwable)e, (Object)context.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
            }
            catch (Throwable ignored) {
                LOGGER.logDebug("couldn't write log. : ", (Throwable)e, new Object[0]);
            }
            return new InternalError(e);
        }
        if (e instanceof VirtualMachineError) {
            FailureLogUtil.logFatal((Throwable)e, (Object)context.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
            throw e;
        }
        FailureLogUtil.logFatal((Throwable)e, (Object)context.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
        return new InternalError(e);
    }

    public Result handleRuntimeException(RuntimeException e, ExecutionContext context) throws RuntimeException {
        if (e instanceof ServiceError) {
            ServiceError error = (ServiceError)((Object)e);
            error.writeLog(context);
            return error;
        }
        if (e instanceof Result.Error) {
            Result.Error error = (Result.Error)e;
            FailureLogUtil.logFatal((Throwable)error, (Object)context.getDataProcessedWhenThrown((Throwable)error), null, (Object[])new Object[0]);
            return error;
        }
        FailureLogUtil.logFatal((Throwable)e, (Object)context.getDataProcessedWhenThrown((Throwable)e), null, (Object[])new Object[0]);
        return new InternalError(e);
    }
}

