/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.HandlerWrapper;
import nablarch.fw.Interceptor;
import nablarch.fw.Result;

public abstract class MethodBinding<TData, TResult>
implements HandlerWrapper<TData, TResult> {
    private final Object delegate;

    public MethodBinding(Object delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    protected abstract Method getMethodBoundTo(TData var1, ExecutionContext var2);

    protected Method getHandleMethod(String name) {
        name = name.toLowerCase();
        for (Method method : this.delegate.getClass().getMethods()) {
            if (!method.getName().toLowerCase().equals(name) || !this.qualifiesAsHandler(method)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public TResult handle(TData req, ExecutionContext ctx) throws Result.NotFound {
        final Method boundMethod = this.getMethodBoundTo(req, ctx);
        if (boundMethod == null) {
            throw new Result.NotFound("Couldn't find method to delegate.: " + req.toString());
        }
        Handler handler = new Handler<TData, TResult>(){

            public TResult handle(TData req, ExecutionContext ctx) {
                try {
                    return boundMethod.invoke(MethodBinding.this.delegate, req, ctx);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (RuntimeException.class.isAssignableFrom(cause.getClass())) {
                        throw (RuntimeException)cause;
                    }
                    if (Error.class.isAssignableFrom(cause.getClass())) {
                        throw (Error)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
        };
        return (TResult)Interceptor.Factory.wrap((Handler)handler, (Annotation[])boundMethod.getAnnotations()).handle(req, ctx);
    }

    public List<Object> getDelegates(TData data, ExecutionContext context) {
        return Arrays.asList(this.delegate);
    }

    protected boolean qualifiesAsHandler(Method method) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 2 && paramTypes[1].equals(ExecutionContext.class);
    }
}

