/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.invoker;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.repository.initialization.Initializable;
import nablarch.core.util.annotation.Published;
import nablarch.fw.invoker.ExecutorServiceFactory;

@Published(tag={"architect"})
public abstract class AbstractExecutorServiceFactory
implements ExecutorServiceFactory,
Initializable {
    private static final Logger LOGGER = LoggerManager.get(AbstractExecutorServiceFactory.class);
    public static final long DEFAULT_TIMEOUT_SECOND = 10L;
    protected long timeoutSecond = 10L;
    protected ExecutorService executorService;

    public void initialize() {
        this.executorService = this.createExecutorService();
        if (this.executorService == null) {
            throw new IllegalStateException("executorService not initialized.");
        }
    }

    protected abstract ExecutorService createExecutorService();

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void startShutdownService() {
        if (!this.needsShutdown()) {
            return;
        }
        LOGGER.logInfo("starting shutdown. no more request will be accepted.", new Object[0]);
        this.executorService.shutdown();
    }

    @Override
    public void shutdownService() {
        if (this.executorService == null) {
            return;
        }
        try {
            this.awaitTermination();
        }
        catch (InterruptedException e) {
            LOGGER.logInfo("interrupted in ExecutorService#awaitTermination.", (Throwable)e, new Object[0]);
            Thread.interrupted();
        }
        this.executorService.shutdownNow();
        LOGGER.logInfo("shutdown finished.", new Object[0]);
    }

    protected boolean awaitTermination() throws InterruptedException {
        return this.executorService.awaitTermination(this.timeoutSecond, TimeUnit.SECONDS);
    }

    protected boolean needsShutdown() {
        return this.executorService != null && !this.executorService.isShutdown();
    }

    public void setTimeoutSecond(long timeoutSecond) {
        this.timeoutSecond = timeoutSecond;
    }
}

