/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.results;

import java.util.Locale;
import nablarch.core.ThreadContext;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.log.basic.LogLevel;
import nablarch.core.message.Message;
import nablarch.core.message.MessageLevel;
import nablarch.core.message.MessageUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Result;

@Published(tag={"architect"})
public abstract class ServiceError
extends Result.Error {
    private LogLevel logLevel = LogLevel.FATAL;
    private String messageId = null;
    private Object[] messageParams = new Object[0];
    private Object[] logOptions = new Object[0];

    public ServiceError() {
    }

    public ServiceError(String message) {
        super(message);
    }

    public ServiceError(Throwable cause) {
        super(cause);
    }

    public ServiceError(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceError(LogLevel logLevel, String messageId, Object ... messageParams) {
        assert (logLevel != null && messageId != null);
        this.logLevel = logLevel;
        this.messageId = messageId;
        this.messageParams = messageParams;
    }

    public ServiceError(LogLevel logLevel, Throwable cause, String messageId, Object ... messageParams) {
        super(cause);
        assert (logLevel != null && messageId != null);
        this.logLevel = logLevel;
        this.messageId = messageId;
        this.messageParams = messageParams;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Object[] getMessageParams() {
        return this.messageParams;
    }

    public String getMessage() {
        if (this.messageId == null) {
            return super.getMessage();
        }
        MessageLevel level = null;
        switch (this.logLevel) {
            case FATAL: 
            case ERROR: {
                level = MessageLevel.ERROR;
                break;
            }
            case WARN: {
                level = MessageLevel.WARN;
                break;
            }
            default: {
                level = MessageLevel.INFO;
            }
        }
        try {
            Message message = MessageUtil.createMessage((MessageLevel)level, (String)this.messageId, (Object[])this.messageParams);
            return message.formatMessage(ThreadContext.getLanguage() != null ? ThreadContext.getLanguage() : Locale.getDefault());
        }
        catch (Throwable e) {
            return "An error happened with messageId = [" + this.messageId + "]" + "(but couldn't get the message contents.)";
        }
    }

    public void writeLog(ExecutionContext context) {
        Object data = context != null ? context.getDataProcessedWhenThrown((Throwable)((Object)this)) : null;
        switch (this.logLevel) {
            case FATAL: {
                FailureLogUtil.logFatal((Throwable)((Object)this), (Object)data, (String)this.messageId, (Object[])this.messageParams, (Object[])this.logOptions);
                break;
            }
            case ERROR: {
                FailureLogUtil.logError((Throwable)((Object)this), (Object)data, (String)this.messageId, (Object[])this.messageParams, (Object[])this.logOptions);
                break;
            }
        }
    }

    public int getStatusCode() {
        return 500;
    }
}

