/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.results;

import nablarch.core.log.basic.LogLevel;
import nablarch.core.util.annotation.Published;
import nablarch.fw.results.InternalError;

@Published(tag={"architect"})
public class TransactionAbnormalEnd
extends InternalError {
    private final int exitCode;

    @Published
    public TransactionAbnormalEnd(int exitCode, String failureCode, Object ... messageOptions) {
        super(LogLevel.FATAL, failureCode, messageOptions);
        TransactionAbnormalEnd.validateExitCode(exitCode);
        this.exitCode = exitCode;
    }

    @Published
    public TransactionAbnormalEnd(int exitCode, Throwable error, String failureCode, Object ... messageOptions) {
        super(LogLevel.FATAL, error, failureCode, messageOptions);
        TransactionAbnormalEnd.validateExitCode(exitCode);
        this.exitCode = exitCode;
    }

    private static void validateExitCode(int exitCode) {
        if (exitCode < 100 || exitCode > 199) {
            throw new IllegalArgumentException("Exit code was invalid range. Please set it in the range of 199 from 100. specified value was:" + exitCode);
        }
    }

    @Override
    @Published(tag={"architect"})
    public int getStatusCode() {
        return this.exitCode;
    }
}

