/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.invoker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HandlerListProtector<T> {
    private ProtectMode protectMode;

    public HandlerListProtector() {
        this(ProtectMode.UNMODIFIABLE);
    }

    public HandlerListProtector(ProtectMode protectMode) {
        this.protectMode = protectMode;
    }

    public List<T> protect(List<T> original) {
        if (original == null) {
            throw new IllegalArgumentException("argument must not be null.");
        }
        return this.protectMode.wrap(original);
    }

    public void setProtectModeExpression(String protectModeValue) {
        this.setProtectMode(ProtectMode.valueOf(protectModeValue));
    }

    public void setProtectMode(ProtectMode protectMode) {
        this.protectMode = protectMode;
    }

    public static enum ProtectMode {
        COPY{

            @Override
            <T> List<T> wrap(List<T> handlerList) {
                ArrayList<T> copied = new ArrayList<T>((int)((double)handlerList.size() * 1.2));
                copied.addAll(handlerList);
                return copied;
            }
        }
        ,
        UNMODIFIABLE{

            @Override
            <T> List<T> wrap(List<T> handlerList) {
                return Collections.unmodifiableList(handlerList);
            }
        }
        ,
        NONE{

            @Override
            <T> List<T> wrap(List<T> handlerList) {
                return handlerList;
            }
        };


        abstract <T> List<T> wrap(List<T> var1);
    }
}

