/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.invoker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExceptionHandler;
import nablarch.fw.ExecutionContext;
import nablarch.fw.InboundHandleable;
import nablarch.fw.OutboundHandleable;
import nablarch.fw.Result;
import nablarch.fw.handler.GlobalErrorHandler;
import nablarch.fw.invoker.PipelineListBuilder;

@Published(tag={"architect"})
public class PipelineInvoker {
    public static final String PROCESSED_HANDLERS_KEY = "nablarch_processed_handlers";
    private PipelineListBuilder handlerListBuilder;
    private ExceptionHandler exceptionHandler = new GlobalErrorHandler();

    public void setHandlerListBuilder(PipelineListBuilder handlerListBuilder) {
        this.handlerListBuilder = handlerListBuilder;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Result invokeInbound(ExecutionContext context) {
        try {
            List<Object> handlerList = this.handlerListBuilder.getHandlerList();
            HashSet<InboundHandleable> processedHandlers = new HashSet<InboundHandleable>();
            context.setRequestScopedVar(PROCESSED_HANDLERS_KEY, processedHandlers);
            for (Object object : handlerList) {
                if (!(object instanceof InboundHandleable)) continue;
                InboundHandleable handler = (InboundHandleable)object;
                Result ret = handler.handleInbound(context);
                if (!ret.isSuccess()) {
                    return ret;
                }
                processedHandlers.add(handler);
            }
            return new Result.Success();
        }
        catch (Error e) {
            return this.handleError(context, e);
        }
        catch (RuntimeException e) {
            return this.handleRuntimeException(context, e);
        }
    }

    public Result invokeOutbound(ExecutionContext context) {
        ArrayList<Object> handlerList = new ArrayList<Object>();
        handlerList.addAll(this.handlerListBuilder.getHandlerList());
        Collections.reverse(handlerList);
        Set<Object> processedHandlers = this.getProcessedHandlers(context);
        Result.Success firstInvalidResult = null;
        Throwable firstThrowable = null;
        for (Object e : handlerList) {
            Result result;
            block7: {
                OutboundHandleable handler;
                if (!(e instanceof OutboundHandleable) || !processedHandlers.contains(handler = (OutboundHandleable)e)) continue;
                result = null;
                try {
                    result = handler.handleOutbound(context);
                }
                catch (Throwable t) {
                    context.setProcessSucceeded(false);
                    try {
                        result = this.handleException(context, t);
                    }
                    catch (Throwable t1) {
                        if (firstThrowable != null) break block7;
                        firstThrowable = t1;
                    }
                }
            }
            if (result == null || result.isSuccess() || firstInvalidResult != null) continue;
            firstInvalidResult = result;
        }
        if (firstThrowable != null) {
            if (firstThrowable instanceof RuntimeException) {
                throw (RuntimeException)firstThrowable;
            }
            throw (Error)firstThrowable;
        }
        return firstInvalidResult != null ? firstInvalidResult : new Result.Success();
    }

    protected Result handleException(ExecutionContext context, Throwable t) {
        if (t instanceof RuntimeException) {
            return this.handleRuntimeException(context, (RuntimeException)t);
        }
        return this.handleError(context, (Error)t);
    }

    protected Set<Object> getProcessedHandlers(ExecutionContext context) {
        HashSet processedHandlers = (HashSet)context.getRequestScopedVar(PROCESSED_HANDLERS_KEY);
        if (processedHandlers == null) {
            processedHandlers = new HashSet();
            context.setRequestScopedVar(PROCESSED_HANDLERS_KEY, processedHandlers);
        }
        return processedHandlers;
    }

    protected Result handleRuntimeException(ExecutionContext context, RuntimeException e) {
        return this.exceptionHandler.handleRuntimeException(e, context);
    }

    protected Result handleError(ExecutionContext context, Error e) throws Error {
        return this.exceptionHandler.handleError(e, context);
    }
}

