/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.handler.threadcontext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nablarch.common.handler.threadcontext.ThreadContextAttribute;
import nablarch.core.ThreadContext;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.InboundHandleable;
import nablarch.fw.OutboundHandleable;
import nablarch.fw.Result;

public class ThreadContextHandler
implements Handler<Object, Object>,
InboundHandleable,
OutboundHandleable {
    private List<ThreadContextAttribute> attributes = new ArrayList<ThreadContextAttribute>();

    public ThreadContextHandler(ThreadContextAttribute ... attributes) {
        this.setAttributes(Arrays.asList(attributes));
    }

    public ThreadContextHandler() {
    }

    public Object handle(Object input, ExecutionContext ctx) {
        this.handleInbound(ctx);
        return ctx.handleNext(input);
    }

    public ThreadContextHandler setAttributes(List<ThreadContextAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Result handleInbound(ExecutionContext context) {
        assert (this.attributes != null);
        ThreadContext.clear();
        for (ThreadContextAttribute attribute : this.attributes) {
            ThreadContext.setObject((String)attribute.getKey(), (Object)attribute.getValue(context.getCurrentRequestObject(), context));
        }
        return new Result.Success();
    }

    public Result handleOutbound(ExecutionContext context) {
        return new Result.Success();
    }
}

