/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Request;
import nablarch.fw.Result;
import nablarch.fw.handler.DispatchHandler;
import nablarch.fw.handler.JavaPackageMappingEntry;

public class RequestPathJavaPackageMapping
extends DispatchHandler<Request<?>, Object, RequestPathJavaPackageMapping> {
    private static final Logger LOGGER = LoggerManager.get(RequestPathJavaPackageMapping.class);
    private static final Pattern MAPPING_RULE = Pattern.compile("((?:[_a-z][_a-zA-Z0-9]*\\.)*)([A-Z][_a-zA-Z0-9]*).*");
    private String basePath = "";
    private String basePackage = "";
    private List<JavaPackageMappingEntry> optionalPackageMappingEntries;
    private String classNameSuffix = "";
    private String classNamePrefix = "";

    @Override
    protected Class<?> getHandlerClass(Request<?> req, ExecutionContext ctx) throws ClassNotFoundException {
        if (!req.getRequestPath().startsWith(this.basePath)) {
            String message = "Couldn't map request.: " + req.getRequestPath();
            LOGGER.logInfo(message, new Object[0]);
            throw new Result.NotFound(message);
        }
        String basePackage = this.getBasePackage(req, ctx);
        String mappedUri = req.getRequestPath().replaceFirst(this.basePath, basePackage + ".").replaceAll("[./]+", ".").replaceAll("^\\.|\\.$", "");
        Matcher m = MAPPING_RULE.matcher(mappedUri);
        if (!m.matches()) {
            String message = "Couldn't map request.: " + mappedUri;
            LOGGER.logInfo(message, new Object[0]);
            throw new Result.NotFound(message);
        }
        String packageName = m.group(1) == null ? "" : m.group(1);
        String className = this.classNamePrefix + m.group(2) + this.classNameSuffix;
        String fqn = packageName + className;
        this.writeDispatchingClassLog(req, ctx, fqn);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Class.forName(fqn, true, loader);
    }

    protected String getBasePackage(Request<?> req, ExecutionContext ctx) {
        if (this.optionalPackageMappingEntries != null) {
            for (JavaPackageMappingEntry entry : this.optionalPackageMappingEntries) {
                boolean appliedTo = entry.getRequestPathMatching().isAppliedTo(req, ctx);
                if (!appliedTo) continue;
                return entry.getBasePackage();
            }
        }
        return this.basePackage;
    }

    public RequestPathJavaPackageMapping() {
        this("", "");
    }

    public RequestPathJavaPackageMapping(String basePath, String basePackage) {
        if (basePath == null || basePackage == null) {
            throw new IllegalArgumentException("The arguments of this constructor must not be null.");
        }
        this.basePath = basePath;
        this.basePackage = basePackage;
    }

    public RequestPathJavaPackageMapping setBasePath(String basePath) {
        if (basePath == null) {
            throw new IllegalArgumentException("BasePath property must not be null.");
        }
        this.basePath = basePath;
        return this;
    }

    public RequestPathJavaPackageMapping setBasePackage(String basePackage) {
        if (basePackage == null) {
            throw new IllegalArgumentException("basePackage property must not be null.");
        }
        this.basePackage = basePackage;
        return this;
    }

    public RequestPathJavaPackageMapping setOptionalPackageMappingEntries(List<JavaPackageMappingEntry> optionalPackageMappingEntries) {
        this.optionalPackageMappingEntries = optionalPackageMappingEntries;
        return this;
    }

    public RequestPathJavaPackageMapping setClassNamePrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null.");
        }
        this.classNamePrefix = prefix;
        return this;
    }

    public RequestPathJavaPackageMapping setClassNameSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("suffix must not be null.");
        }
        this.classNameSuffix = suffix;
        return this;
    }
}

