/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.ThreadContext;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;

@Published(tag={"architect"})
public abstract class RewriteRule<TData, TSelf> {
    private static final Pattern COND_LINE_FORMAT = Pattern.compile("^(!)?\\%\\{(?:([-_a-zA-Z][-_a-zA-Z0-9]+):)?([-_.a-zA-Z][-_.a-zA-Z0-9]+)\\}\\s+(.*)");
    private Pattern pattern;
    private String rewriteTo;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<Export> exports = new ArrayList<Export>();
    private static final Pattern PLACE_HOLDER = Pattern.compile("\\$\\{(?:([1-9][0-9]*|0)|(?:([a-z]+)\\:)?([-_.a-zA-Z][-_.a-zA-Z0-9]+)(?:\\:((?:[1-9][0-9]*|0)))?)\\}", 2);

    protected abstract String getPathToRewrite(TData var1);

    protected abstract void applyRewrittenPath(String var1, TData var2);

    protected Object getParam(String scope, String name, TData data, ExecutionContext context) {
        return "request".equals(scope) ? context.getRequestScopedVar(name) : ("session".equals(scope) ? context.getSessionScopedVar(name) : ("thread".equals(scope) ? ThreadContext.getObject((String)name) : null));
    }

    protected void exportParam(String scope, String name, String value, TData data, ExecutionContext context) {
        if ("request".equals(scope)) {
            context.setRequestScopedVar(name, (Object)value);
        } else if ("session".equals(scope)) {
            context.setSessionScopedVar(name, (Object)value);
        } else if ("thread".equals(scope)) {
            ThreadContext.setObject((String)name, (Object)value);
        }
    }

    public String rewrite(TData data, ExecutionContext context) {
        String fromPath = this.getPathToRewrite(data);
        String toPath = this.rewriteTo;
        HashMap<String, List<String>> backRefs = new HashMap<String, List<String>>();
        for (Condition cond : this.conditions) {
            Object value;
            if (cond.satisfiedBy(value = this.getParam(cond.paramType, cond.paramName, data, context), backRefs)) continue;
            return null;
        }
        Matcher m = this.pattern.matcher(fromPath);
        if (!m.matches()) {
            return null;
        }
        ArrayList<String> backRef = new ArrayList<String>(m.groupCount());
        for (int i = 0; i <= m.groupCount(); ++i) {
            backRef.add(m.group(i));
        }
        backRefs.put("#", backRef);
        String rewrittenPath = toPath == null ? fromPath : this.interpolate(toPath, backRefs, data, context);
        this.applyRewrittenPath(rewrittenPath, data);
        for (Export export : this.exports) {
            this.exportParam(export.paramType, export.paramName, this.interpolate(export.paramValue, backRefs, data, context), data, context);
        }
        return rewrittenPath;
    }

    private String interpolate(String str, Map<String, List<String>> backRefs, TData data, ExecutionContext context) {
        Matcher placeHolder = PLACE_HOLDER.matcher(str);
        String result = str;
        while (placeHolder.find()) {
            Object value;
            if (placeHolder.group(1) != null) {
                value = backRefs.get("#").get(Integer.valueOf(placeHolder.group(1)));
            } else {
                String type = placeHolder.group(2) == null ? "" : placeHolder.group(2);
                String name = placeHolder.group(3);
                String backRefNum = placeHolder.group(4);
                value = backRefNum == null ? this.getParam(type, name, data, context) : backRefs.get(type + ":" + name).get(Integer.valueOf(backRefNum));
            }
            result = result.replace(placeHolder.group(), value == null ? "" : StringUtil.toString((Object)value));
        }
        return result;
    }

    public TSelf setPattern(String pattern) {
        if (StringUtil.isNullOrEmpty((String)pattern)) {
            throw new IllegalArgumentException("The property [pattern] must not be null or blank.");
        }
        this.pattern = Pattern.compile(pattern.trim());
        return (TSelf)this;
    }

    public TSelf setRewriteTo(String rewriteTo) {
        if (StringUtil.isNullOrEmpty((String)rewriteTo)) {
            throw new IllegalArgumentException("The property [rewriteTo] must not be null or blank.");
        }
        this.rewriteTo = rewriteTo;
        return (TSelf)this;
    }

    public TSelf setExports(List<String> exportDefinitions) {
        this.exports.clear();
        for (String def : exportDefinitions) {
            this.addExport(def);
        }
        return (TSelf)this;
    }

    public TSelf addExport(String exportDefinition) {
        this.exports.add(new Export(exportDefinition));
        return (TSelf)this;
    }

    public TSelf setConditions(List<String> conditions) {
        this.conditions.clear();
        for (String cond : conditions) {
            this.addCondition(cond);
        }
        return (TSelf)this;
    }

    public TSelf addCondition(String condition) {
        this.conditions.add(new Condition(condition));
        return (TSelf)this;
    }

    private static final class Export {
        private final String paramType;
        private final String paramName;
        private final String paramValue;

        private Export(String line) {
            Matcher m = COND_LINE_FORMAT.matcher(line);
            if (!m.matches() || m.group(1) != null) {
                throw new IllegalArgumentException("invalid rewrite rule condition : " + line);
            }
            this.paramType = m.group(2) == null ? "" : m.group(2);
            this.paramName = m.group(3);
            this.paramValue = m.group(4);
        }
    }

    private static final class Condition {
        private final String paramType;
        private final String paramName;
        private final Pattern pattern;
        private final boolean invertMatch;

        private Condition(String line) {
            Matcher m = COND_LINE_FORMAT.matcher(line);
            if (!m.matches()) {
                throw new IllegalArgumentException("invalid rewrite rule condition : " + line);
            }
            this.invertMatch = m.group(1) != null;
            this.paramType = m.group(2) == null ? "" : m.group(2);
            this.paramName = m.group(3);
            this.pattern = Pattern.compile(m.group(4), 4);
        }

        public boolean satisfiedBy(Object value, Map<String, List<String>> backRefs) {
            String val = value == null ? "" : StringUtil.toString((Object)value);
            Matcher m = this.pattern.matcher(val);
            boolean found = m.find();
            if (found) {
                ArrayList<String> backRef = new ArrayList<String>();
                for (int i = 0; i <= m.groupCount(); ++i) {
                    backRef.add(m.group(i));
                }
                backRefs.put(this.paramType + ":" + this.paramName, backRef);
            }
            return found ^ this.invertMatch;
        }
    }
}

