/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.invoker;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.invoker.ExecutorServiceFactory;
import nablarch.fw.invoker.HandlerListInvoker;

public class AsyncHandlerListInvoker<TData, TResult>
implements HandlerListInvoker<TData, Future<TResult>> {
    private HandlerListInvoker<TData, TResult> handlerListInvoker;
    private ExecutorServiceFactory executorServiceFactory;

    @Published(tag={"architect"})
    public AsyncHandlerListInvoker() {
    }

    @Override
    public Future<TResult> invokeHandlerList(TData input, ExecutionContext context) {
        Callable<TResult> caller = this.createCallable(this.getHandlerListInvoker(), input, context);
        ExecutorService service = this.getExecutorService();
        return service.submit(caller);
    }

    @Published(tag={"architect"})
    protected Callable<TResult> createCallable(final HandlerListInvoker<TData, TResult> handlerListInvoker, final TData input, final ExecutionContext context) {
        return new Callable<TResult>(){

            @Override
            public TResult call() throws Exception {
                return handlerListInvoker.invokeHandlerList(input, context);
            }
        };
    }

    private HandlerListInvoker<TData, TResult> getHandlerListInvoker() {
        if (this.handlerListInvoker == null) {
            throw new IllegalStateException("handlerListInvoker must be set.");
        }
        return this.handlerListInvoker;
    }

    private ExecutorService getExecutorService() {
        if (this.executorServiceFactory == null) {
            throw new IllegalStateException("executorServiceFactory must be set.");
        }
        return this.executorServiceFactory.getExecutorService();
    }

    public void setHandlerListInvoker(HandlerListInvoker<TData, TResult> handlerListInvoker) {
        this.handlerListInvoker = handlerListInvoker;
    }

    public void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }
}

