/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.results;

import java.util.Date;
import nablarch.core.log.basic.LogLevel;
import nablarch.core.util.annotation.Published;
import nablarch.fw.results.ServiceError;

@Published(tag={"architect"})
public class ServiceUnavailable
extends ServiceError {
    private static final String DEFAULT_MESSAGE = "This service is currently unable to handle your request due to a temporary overloading or maintenance. ";
    private Long retryAfter = null;

    public ServiceUnavailable() {
        this(DEFAULT_MESSAGE);
    }

    public ServiceUnavailable(String message) {
        super(message);
    }

    public ServiceUnavailable(Throwable cause) {
        super(cause);
    }

    public ServiceUnavailable(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceUnavailable(LogLevel logLevel, String messageId, Object ... messageParams) {
        super(logLevel, messageId, messageParams);
    }

    public ServiceUnavailable(LogLevel logLevel, Throwable cause, String messageId, Object ... messageParams) {
        super(logLevel, cause, messageId, messageParams);
    }

    @Override
    public int getStatusCode() {
        return 503;
    }

    public ServiceUnavailable setRetryAfter(Date retryAfter) {
        this.retryAfter = retryAfter == null ? null : Long.valueOf(retryAfter.getTime());
        return this;
    }

    public Date getRetryAfter() {
        return this.retryAfter == null ? null : new Date(this.retryAfter);
    }
}

