/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.httpserver;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.HttpServer;
import nablarch.fw.web.MockHttpRequest;
import nablarch.fw.web.ResourceLocator;
import nablarch.fw.web.httpserver.LazySessionInvalidationFilter;
import nablarch.fw.web.servlet.WebFrontController;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

@Published(tag={"architect"})
public class HttpServerJetty9
extends HttpServer {
    private Server jetty;
    private LocalConnector localConnector;

    public HttpServerJetty9 start() {
        this.jetty = new Server(this.getPort());
        ServerConnector conn = new ServerConnector(this.jetty);
        this.initialize((Connector)conn);
        try {
            this.jetty.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpServerJetty9 startLocal() {
        this.jetty = new Server();
        this.localConnector = new LocalConnector(this.jetty);
        this.initialize((Connector)this.localConnector);
        try {
            this.jetty.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpServer join() {
        try {
            this.jetty.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public HttpResponse handle(HttpRequest req, ExecutionContext sourceContext) {
        if (this.localConnector == null) {
            throw new RuntimeException("this server is not running on a local connector. you must call startLocal() method beforehand.");
        }
        String host = req.getHost();
        if (host == null || host.isEmpty()) {
            ((MockHttpRequest)req).setHost("127.0.0.1");
        }
        CountDownLatch latch = new CountDownLatch(1);
        sourceContext.setRequestScopedVar("nablarch.jetty.connector.larch", (Object)latch);
        try {
            byte[] rawReq = req.toString().getBytes();
            ByteBuffer response = this.localConnector.getResponse(ByteBuffer.wrap(rawReq));
            latch.await(10L, TimeUnit.SECONDS);
            byte[] rawRes = response.array();
            HttpResponse res = HttpResponse.parse((byte[])rawRes);
            if (this.isHttpDumpEnabled()) {
                this.dumpHttpMessage(req, res);
            }
            return res;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initialize(Connector conn) {
        this.jetty.addConnector(conn);
        this.deploy();
    }

    private void deploy() {
        WebAppContext webApp = new WebAppContext();
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionIdPathParameterName("none");
        webApp.setSessionHandler(sessionHandler);
        webApp.setContextPath(this.getServletContextPath());
        webApp.setBaseResource((Resource)this.toResourceCollection(this.getWarBasePaths()));
        webApp.setClassLoader(Thread.currentThread().getContextClassLoader());
        StandardJarScanner scanner = new StandardJarScanner();
        scanner.setScanManifest(false);
        webApp.setAttribute(JarScanner.class.getName(), (Object)scanner);
        webApp.setPersistTempDirectory(true);
        webApp.addFilter(LazySessionInvalidationFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        WebFrontController webFrontController = this.getWebFrontController();
        webApp.addFilter(new FilterHolder((Filter)webFrontController), "/*", EnumSet.of(DispatcherType.REQUEST));
        Configuration[] configurations = new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new AnnotationConfiguration()};
        webApp.setConfigurations(configurations);
        File tmpDir = this.getTempDirectory();
        if (tmpDir != null) {
            webApp.setTempDirectory(tmpDir);
        }
        this.jetty.setHandler((Handler)webApp);
    }

    private ResourceCollection toResourceCollection(List<ResourceLocator> warBasePaths) {
        String[] realPaths = new String[warBasePaths.size()];
        for (int i = 0; i < warBasePaths.size(); ++i) {
            realPaths[i] = warBasePaths.get(i).getRealPath();
        }
        try {
            return new ResourceCollection(realPaths);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("invalid warBasePath. " + warBasePaths, e);
        }
    }
}

